# 中国革命战争的战略问题  
（一九三六年十二月）  
  
> 毛泽东的这部著作，是为着总结第二次国内革命战争的经验而写的，当时曾在建立在陕北的红军大学作过讲演。据著者说，这部著作只完成五章，尚有战略进攻、政治工作及其他问题，因为西安事变发生，没有工夫再写，就搁笔了。这是第二次国内革命战争时期党内在军事问题上的一场大争论的结果，是表示一个路线反对另一个路线的意见。对于这个路线上的争论，一九三五年一月中共中央召开的遵义会议作出了结论，肯定了毛泽东的意见，而否定了错误路线的意见。在一九三五年十月中共中央移到陕北以后，毛泽东随即在十二月作了《论反对日本帝国主义的策略》的报告，系统地解决了第二次国内革命战争时期党的政治路线上的问题。第二年，即一九三六年，毛泽东又写了这部著作，系统地说明了有关中国革命战争战略方面的诸问题。   
  
## 第一章　如何研究战争  

### 第一节　战争规律是发展的  

  
　　战争的规律——这是任何指导战争的人不能不研究和不能不解决的问题。   
　　革命战争的规律——这是任何指导革命战争的人不能不研究和不能不解决的问题。   
　　中国革命战争的规律——这是任何指导中国革命战争的人不能不研究和不能不解决的问题。   
　　我们现在是从事战争，我们的战争是革命战争，我们的革命战争是在中国这个半殖民地的半封建的国度里进行的。因此，我们不但要研究一般战争的规律，还要研究特殊的革命战争的规律，还要研究更加特殊的中国革命战争的规律。   
　　大家明白，不论做什么事，不懂得那件事的情形，它的性质，它和它以外的事情的关联，就不知道那件事的规律，就不知道如何去做，就不能做好那件事。   
　　战争——从有私有财产和有阶级以来就开始了的、用以解决阶级和阶级、民族和民族、国家和国家、政治集团和政治集团之间、在一定发展阶段上的矛盾的一种最高的斗争形式。不懂得它的情形，它的性质，它和它以外事情的关联，就不知道战争的规律，就不知道如何指导战争，就不能打胜仗。   
　　革命战争——革命的阶级战争和革命的民族战争，在一般战争的情形和性质之外，有它的特殊的情形和性质。因此，在一般的战争规律之外，有它的一些特殊的规律。不懂得这些特殊的情形和性质，不懂得它的特殊的规律，就不能指导革命战争，就不能在革命战争中打胜仗。   
　　中国革命战争——不论是国内战争或民族战争，是在中国的特殊环境之内进行的，比较一般的战争，一般的革命战争，又有它的特殊的情形和特殊的性质。因此，在一般战争和一般革命战争的规律之外，又有它的一些特殊的规律。如果不懂得这些，就不能在中国革命战争中打胜仗。   
　　所以，我们应该研究一般战争的规律；也应该研究革命战争的规律；最后，我们还应该研究中国革命战争的规律。   
　　有一种人的意见是不对的，我们早已批驳了这种意见了；他们说：只要研究一般战争的规律就得了，具体地说，只要照着反动的中国政府或反动的中国军事学校出版的那些军事条令去做就得了。他们不知道：这些条令仅仅是一般战争的规律，并且全是抄了外国的，如果我们一模一样地照抄来用，丝毫也不变更其形式和内容，就一定是削足适履，要打败仗。他们的理由是：过去流过血得来的东西，为什么要不得？他们不知道：我们固然应该尊重过去流血的经验，但是还应该尊重自己流血的经验。   
　　又有一种人的意见也是不对的，我们也早已批驳了这种意见了；他们说：只要研究俄国革命战争的经验就得了，具体地说，只要照着苏联内战的指导规律和苏联军事机关颁布的军事条令去做就得了。他们不知道：苏联的规律和条令，包含着苏联内战和苏联红军的特殊性，如果我们一模一样地抄了来用，不允许任何的变更，也同样是削足适履，要打败仗。这些人的理由是：苏联的战争是革命的战争，我们的战争也是革命的战争，而且苏联是胜利了，为什么还有取舍的余地？他们不知道：我们固然应该特别尊重苏联的战争经验，因为它是最近代的革命战争的经验，是在列宁、斯大林指导之下获得的；但是我们还应该尊重中国革命战争的经验，因为中国革命和中国红军又有许多特殊的情况。   
　　再有一种人的意见也是不对的，我们也早就批驳了这种意见了；他们说：一九二六年至一九二七年的北伐战争的经验是最好的，我们应该学习它，具体地说，学北伐战争的长驱直进和夺取大城市。他们不知道：北伐战争的经验是应该学习的，但是不应该刻板地抄用，因为我们现时战争的情况已经变化了。我们只应该采用北伐战争中那些在现时情况下还能适用的东西，我们应该按照现时情况规定我们自己的东西。   
　　由此看来，战争情况的不同，决定着不同的战争指导规律，有时间、地域和性质的差别。从时间的条件说，战争和战争指导规律都是发展的，各个历史阶段有各个历史阶段的特点，因而战争规律也各有其特点，不能呆板地移用于不同的阶段。从战争的性质看，革命战争和反革命战争，各有其不同的特点，因而战争规律也各有其特点，不能呆板地互相移用。从地域的条件看，各个国家各个民族特别是大国家大民族均有其特点，因而战争规律也各有其特点，同样不能呆板地移用。我们研究在各个不同历史阶段、各个不同性质、不同地域和民族的战争的指导规律，应该着眼其特点和着眼其发展，反对战争问题上的机械论。   
　　还不止此。对于一个指挥员来说，起初会指挥小兵团，后来又会指挥大兵团，这对于他是进步了，发展了。一个地方和许多地方也不相同。起初会在某一熟悉的地方作战，后来在许多地方也会作战，这对于一个指挥员又是进步了，发展了。因为敌我双方的技术、战术、战略的发展，一个战争中各阶段的情形也不相同。在低级阶段会指挥的，到了高级阶段也会指挥，这对于一个指挥员更是进步和发展了。只能适应于一定兵团、一定地方和战争发展的一定阶段，这叫做没有进步和没有发展。有一种人，抱着一技之长和一孔之见，再也没有进步，这对革命虽则在一地一时有些作用，但是没有大的作用。我们要求有大的作用的战争指导者。一切战争指导规律，依照历史的发展而发展，依照战争的发展而发展；一成不变的东西是没有的。   
### 第二节　战争的目的在于消灭战争  

  
　　战争——这个人类互相残杀的怪物，人类社会的发展终久要把它消灭的，而且就在不远的将来会要把它消灭的。但是消灭它的方法只有一个，就是用战争反对战争，用革命战争反对反革命战争，用民族革命战争反对民族反革命战争，用阶级革命战争反对阶级反革命战争。历史上的战争，只有正义的和非正义的两类。我们是拥护正义战争反对非正义战争的。一切反革命战争都是非正义的，一切革命战争都是正义的。人类的战争生活时代将要由我们之手而结束，我们所进行的战争，毫无疑义地是属于最后战争的一部分。但是我们所面临的战争，毫无疑义又是最大的和最残酷的战争的一部分。最大的和最残酷的非正义的反革命的战争，迫临在我们的头上，我们如果不打起正义战争的旗帜，人类的大多数就要遭受摧残。人类正义战争的旗帜是拯救人类的旗帜，中国正义战争的旗帜是拯救中国的旗帜。人类的大多数和中国人的大多数所举行的战争，毫无疑义地是正义的战争，是拯救人类拯救中国的至高无上的荣誉的事业，是把全世界历史转到新时代的桥梁。人类社会进步到消灭了阶级，消灭了国家，到了那时，什么战争也没有了，反革命战争没有了，革命战争也没有了，非正义战争没有了，正义战争也没有了，这就是人类的永久和平的时代。我们研究革命战争的规律，出发于我们要求消灭一切战争的志愿，这是区别我们共产党人和一切剥削阶级的界线。   
### 第三节　战略问题是研究战争全局的规律的东西  

  
　　只要有战争，就有战争的全局。世界可以是战争的一全局，一国可以是战争的一全局，一个独立的游击区、一个大的独立的作战方面，也可以是战争的一全局。凡属带有要照顾各方面和各阶段的性质的，都是战争的全局。   
　　研究带全局性的战争指导规律，是战略学的任务。研究带局部性的战争指导规律，是战役学和战术学的任务。   
　　要求战役指挥员和战术指挥员了解某种程度的战略上的规律，何以成为必要呢？因为懂得了全局性的东西，就更会使用局部性的东西，因为局部性的东西是隶属于全局性的东西的。说战略胜利取决于战术胜利的这种意见是错误的，因为这种意见没有看见战争的胜败的主要和首先的问题，是对于全局和各阶段的关照得好或关照得不好。如果全局和各阶段的关照有了重要的缺点或错误，那个战争是一定要失败的。说“一着不慎，满盘皆输”，乃是说的带全局性的，即对全局有决定意义的一着，而不是那种带局部性的即对全局无决定意义的一着。下棋如此，战争也是如此。   
　　然而全局性的东西，不能脱离局部而独立，全局是由它的一切局部构成的。有的时候，有些局部破坏了或失败了，全局可以不起重大的影响，就是因为这些局部不是对于全局有决定意义的东西。战争中有些战术上或战役上的失败或不成功，常常不至于引起战争全局的变坏，就是因为这些失败不是有决定意义的东西。但若组成战争全局的多数战役失败了，或有决定意义的某一二个战役失败了，全局就立即起变化。这里说的多数战役和某一二个战役，就都是决定的东西了。战争历史中有在连战皆捷之后吃了一个败仗以至全功尽弃的，有在吃了许多败仗之后打了一个胜仗因而开展了新局面的。这里说的“连战皆捷”和“许多败仗”，都是局部性的，对于全局不起决定作用的东西。这里说的“一个败仗”和“一个胜仗”，就都是决定的东西了。所有这些，都在说明关照全局的重要性。指挥全局的人，最要紧的，是把自己的注意力摆在照顾战争的全局上面。主要地是依据情况，照顾部队和兵团的组成问题，照顾两个战役之间的关系问题，照顾各个作战阶段之间的关系问题，照顾我方全部活动和敌方全部活动之间的关系问题，这些都是最吃力的地方，如果丢了这个去忙一些次要的问题，那就难免要吃亏了。   
　　说到全局和局部的关系，不但战略和战役的关系是如此，战役和战术的关系也是如此。师的动作和团营动作的关系，连的动作和排班动作的关系，就是实例。任何一级的首长，应当把自己注意的重心，放在那些对于他所指挥的全局说来最重要最有决定意义的问题或动作上，而不应当放在其他的问题或动作上。   
　　说重要，说有决定意义，不能按照一般的或抽象的情况去规定，必须按照具体的情况去规定。作战时选择突击方向和突击点，要按照当前的敌情、地形和自己兵力的情况去规定。在给养丰富的地方要注意不使战士吃得太饱，在给养不足的地方却要注意不使战士饿肚。在白色区域，可以因为仅仅一个消息的走漏而使尔后的战斗失败；在红色区域，则走漏消息的问题常常不是最重要的。某些战役，高级指挥员有亲自参加之必要，其他则无此必要。一个军事学校，最重要的问题，是选择校长教员和规定教育方针。一个民众大会，主要应注意动员民众到会和提出恰当的口号。如此等等。总之，一个原则，就是注意于那些有关全局的重要的关节。   
　　学习战争全局的指导规律，是要用心去想一想才行的。因为这种全局性的东西，眼睛看不见，只能用心思去想一想才能懂得，不用心思去想，就不会懂得。但是全局是由局部构成的，有局部经验的人，有战役战术经验的人，如肯用心去想一想，就能够明白那些更高级的东西。战略问题，如所谓照顾敌我之间的关系，照顾各个战役之间或各个作战阶段之间的关系，照顾有关全局的（有决定意义的）某些部分，照顾全盘情况中的特点，照顾前后方之间的关系，照顾消耗和补充，作战和休息，集中和分散，攻击和防御，前进和后退，荫蔽和暴露，主攻方面和助攻方面，突击方面和钳制方面，集中指挥和分散指挥，持久战和速决战，阵地战和运动战，本军和友军，这些兵种和那些兵种，上级和下级，干部和兵员，老兵和新兵，高级干部和下级干部，老干部和新干部，红色区域和白色区域，老区和新区，中心区和边缘区，热天和冷天，胜仗和败仗，大兵团和小兵团，正规军和游击队，消灭敌人和争取群众，扩大红军和巩固红军，军事工作和政治工作，过去的任务和现在的任务，现在的任务和将来的任务，那种情况下的任务和这种情况下的任务，固定战线和非固定战线，国内战争和民族战争，这一历史阶段和那一历史阶段，等等问题的区别和联系，都是眼睛看不见的东西，但若用心去想一想，也就都可以了解，都可以捉住，都可以精通。这就是说，能够把战争或作战的一切重要的问题，都提到较高的原则性上去解决。达到这个目的，就是研究战略问题的任务。   
### 第四节　重要的问题在善于学习  

  
　　为什么要组织红军？因为要使用它去战胜敌人。为什么要学习战争规律？因为要使用这些规律于战争。   
　　学习不是容易的事情，使用更加不容易。战争的学问拿在讲堂上，或在书本中，很多人尽管讲得一样头头是道，打起仗来却有胜负之分。战争史和我们自己的战争生活，都证明了这一点。   
　　那末，关键在哪里呢？   
　　我们不能要求事实上的常胜将军，这是从古以来就很少的。我们要求在战争过程中一般地打胜仗的勇敢而明智的将军——智勇双全的将军。要达到智勇双全这一点，有一种方法是要学的，学习的时候要用这种方法，使用的时候也要用这种方法。   
　　什么方法呢？那就是熟识敌我双方各方面的情况，找出其行动的规律，并且应用这些规律于自己的行动。   
　　许多国家颁布的军事条令书上，都指示了“按照情况活用原则”的必要，又都指示了打败仗时的处置方法。前者是不要指挥员因死用原则而主观地犯错误；后者是当着指挥员主观地犯了错误，或客观情况起了非所预料的和不可抗的变化时，告诉指挥员怎样去处置。   
　　为什么主观上会犯错误呢？就是因为战争或战斗的部署和指挥不适合当时当地的情况，主观的指导和客观的实在情况不相符合，不对头，或者叫做没有解决主观和客观之间的矛盾。人办一切事情都难免这种情形，有比较地会办和比较地不会办之分罢了。事情要求比较地会办，军事上就要求比较地多打胜仗，反面地说，要求比较地少打败仗。这里的关键，就在于把主观和客观二者之间好好地符合起来。   
　　举战术的例子来说。攻击点选在敌人阵地的某一翼，而那里正是敌人的薄弱部，突击因而成功，这叫做主观和客观相符合，也就是指挥员的侦察、判断和决心，和敌人及其配置的实在情形相符合。如果攻击点选在另一翼，或中央，结果正碰在敌人的钉子上，攻不进去，就叫做不相符合。攻击时机的适当，预备队使用的不迟不早，以及各种战斗处置和战斗动作都利于我不利于敌，便是整个战斗中主观指挥和客观情况统统相符合。统统相符合的事，在战争或战斗中是极其少有的，这是因为战争或战斗的双方是成群的武装着的活人，而又互相保持秘密的缘故，这和处置静物或日常事件是大不相同的。然而只要做到指挥大体上适合情况，即在有决定意义的部分适合情况，那就是胜利的基础了。   
　　指挥员的正确的部署来源于正确的决心，正确的决心来源于正确的判断，正确的判断来源于周到的和必要的侦察，和对于各种侦察材料的联贯起来的思索。指挥员使用一切可能的和必要的侦察手段，将侦察得来的敌方情况的各种材料加以去粗取精、去伪存真、由此及彼、由表及里的思索，然后将自己方面的情况加上去，研究双方的对比和相互的关系，因而构成判断，定下决心，作出计划，——这是军事家在作出每一个战略、战役或战斗的计划之前的一个整个的认识情况的过程。粗心大意的军事家，不去这样做，把军事计划建立在一相情愿的基础之上，这种计划是空想的，不符合于实际的。鲁莽的专凭热情的军事家之所以不免于受敌人的欺骗，受敌人表面的或片面的情况的引诱，受自己部下不负责任的无真知灼见的建议的鼓动，因而不免于碰壁，就是因为他们不知道或不愿意知道任何军事计划，是应该建立于必要的侦察和敌我情况及其相互关系的周密思索的基础之上的缘故。   
　　认识情况的过程，不但存在于军事计划建立之前，而且存在于军事计划建立之后。当执行某一计划时，从开始执行起，到战局终结止，这是又一个认识情况的过程，即实行的过程。此时，第一个过程中的东西是否符合于实况，需要重新加以检查。如果计划和情况不符合，或者不完全符合，就必须依照新的认识，构成新的判断，定下新的决心，把已定计划加以改变，使之适合于新的情况。部分地改变的事差不多每一作战都是有的，全部地改变的事也是间或有的。鲁莽家不知改变，或不愿改变，只是一味盲干，结果又非碰壁不可。   
　　上面说的是一个战略的行动，或一个战役和战斗的行动。经验多的军人，假使他是虚心学习的，他摸熟了自己的部队（指挥员、战斗员、武器、给养等等及其总体）的脾气，又摸熟了敌人的部队（同样，指挥员、战斗员、武器、给养等等及其总体）的脾气，摸熟了一切和战争有关的其他的条件如政治、经济、地理、气候等等，这样的军人指导战争或作战，就比较地有把握，比较地能打胜仗。这是在长时间内认识了敌我双方的情况，找出了行动的规律，解决了主观和客观的矛盾的结果。这一认识过程是非常重要的，没有这一种长时间的经验，要了解和把握整个战争的规律是困难的。做一个真正能干的高级指挥员，不是初出茅庐或仅仅善于在纸上谈兵的角色所能办到的，必须在战争中学习才能办得到。   
　　一切带原则性的军事规律，或军事理论，都是前人或今人做的关于过去战争经验的总结。这些过去的战争所留给我们的血的教训，应该着重地学习它。这是一件事。然而还有一件事，即是从自己经验中考证这些结论，吸收那些用得着的东西，拒绝那些用不着的东西，增加那些自己所特有的东西。这后一件事是十分重要的，不这样做，我们就不能指导战争。   
　　读书是学习，使用也是学习，而且是更重要的学习。从战争学习战争——这是我们的主要方法。没有进学校机会的人，仍然可以学习战争，就是从战争中学习。革命战争是民众的事，常常不是先学好了再干，而是干起来再学习，干就是学习。从“老百姓”到军人之间有一个距离，但不是万里长城，而是可以迅速地消灭的，干革命，干战争，就是消灭这个距离的方法。说学习和使用不容易，是说学得彻底，用得纯熟不容易。说老百姓很快可以变成军人，是说此门并不难入。把二者总合起来，用得着中国一句老话：“世上无难事，只怕有心人。”入门既不难，深造也是办得到的，只要有心，只要善于学习罢了。   
　　军事的规律，和其他事物的规律一样，是客观实际⑴在我们头脑中的反映，除了我们的头脑以外，一切都是客观实际的东西。因此，学习和认识的对象，包括敌我两方面，这两方面都应该看成研究的对象，只有我们的头脑（思想）才是研究的主体。有一种人，明于知己，暗于知彼，又有一种人，明于知彼，暗于知己，他们都是不能解决战争规律的学习和使用的问题的。中国古代大军事学家孙武子⑵书上“知彼知己，百战不殆”这句话，是包括学习和使用两个阶段而说的，包括从认识客观实际中的发展规律，并按照这些规律去决定自己行动克服当前敌人而说的；我们不要看轻这句话。   
　　战争是民族和民族、国家和国家、阶级和阶级、政治集团和政治集团之间互相斗争的最高形式；一切关于战争的规律，都是进行战争的民族、国家、阶级、政治集团为了争取自己的胜利而使用的。战争的胜负，主要地决定于作战双方的军事、政治、经济、自然诸条件，这是没有问题的。然而不仅仅如此，还决定于作战双方主观指导的能力。军事家不能超过物质条件许可的范围外企图战争的胜利，然而军事家可以而且必须在物质条件许可的范围内争取战争的胜利。军事家活动的舞台建筑在客观物质条件的上面，然而军事家凭着这个舞台，却可以导演出许多有声有色威武雄壮的活剧来。因此，我们红军的指导者，在既定的客观物质基础即军事、政治、经济、自然诸条件之上，就必须发挥我们的威力，提挈全军，去打倒那些民族的和阶级的敌人，改变这个不好的世界。这里就用得着而且必须用我们的主观指导的能力。我们不许可任何一个红军指挥员变为乱撞乱碰的鲁莽家；我们必须提倡每个红军指挥员变为勇敢而明智的英雄，不但有压倒一切的勇气，而且有驾驭整个战争变化发展的能力。指挥员在战争的大海中游泳，他们不使自己沉没，而要使自己决定地有步骤地达到彼岸。指导战争的规律，就是战争的游泳术。以上是我们的方法。   
## 第二章　中国共产党和中国革命战争  

  
　　自一九二四年开始的中国革命战争，已经过去了两个阶段，即一九二四年至一九二七年的阶段和一九二七年至一九三六年的阶段；今后则是抗日民族革命战争的阶段。这三个阶段的革命战争，都是中国无产阶级及其政党中国共产党所领导的。中国革命战争的主要敌人，是帝国主义和封建势力。中国资产阶级虽然在某种历史时机可以参加革命战争，然而由于它的自私自利性和政治上经济上的缺乏独立性，不愿意也不能领导中国革命战争走上彻底胜利的道路。中国农民群众和城市小资产阶级群众，是愿意积极地参加革命战争，并愿意使战争得到彻底胜利的。他们是革命战争的主力军；然而他们的小生产的特点，使他们的政治眼光受到限制（一部分失业群众则具有无政府思想），所以他们不能成为战争的正确的领导者。因此，在无产阶级已经走上政治舞台的时代，中国革命战争的领导责任，就不得不落到中国共产党的肩上。在这种时候，任何的革命战争如果没有或违背无产阶级和共产党的领导，那个战争是一定要失败的。因为半殖民地的中国的社会各阶层和各种政治集团中，只有无产阶级和共产党，才最没有狭隘性和自私自利性，最有远大的政治眼光和最有组织性，而且也最能虚心地接受世界上先进的无产阶级及其政党的经验而用之于自己的事业。因此，只有无产阶级和共产党能够领导农民、城市小资产阶级和资产阶级，克服农民和小资产阶级的狭隘性，克服失业者群的破坏性，并且还能够克服资产阶级的动摇和不彻底性（如果共产党的政策不犯错误的话），而使革命和战争走上胜利的道路。   
　　一九二四年至一九二七年的革命战争，基本地说，是在国际无产阶级和中国无产阶级及其政党对于中国民族资产阶级及其政党的政治影响和政治合作之下进行的。然而当着革命和战争的紧急关头，首先由于大资产阶级的叛变，同时也由于革命队伍中机会主义者的自动地放弃革命领导权，这次革命战争就失败了。   
　　一九二七年至现在的土地革命战争，是在新的情况之下进行的。战争的敌人不但是帝国主义，而且是大资产阶级和大地主的联盟。民族资产阶级则做了大资产阶级的尾巴。领导这个革命战争的惟有共产党，共产党已经形成了对于革命战争的绝对的领导权。共产党的这种绝对的领导权，是使革命战争坚持到底的最主要的条件。没有共产党的这种绝对的领导，是不能设想革命战争能有这样的坚持性的。   
　　中国共产党是英勇坚决地领导了中国的革命战争，在十五年的漫长岁月中⑶，在全国人民面前，表示了自己是人民的朋友，每一天都是为了保护人民的利益，为了人民的自由解放，站在革命战争的最前线。   
　　中国共产党以自己艰苦奋斗的经历，以几十万英勇党员和几万英勇干部的流血牺牲，在全民族几万万人中间起了伟大的教育作用。中国共产党在革命斗争中的伟大的历史成就，使得今天处在民族敌人侵入的紧急关头的中国有了救亡图存的条件，这个条件就是有了一个为大多数人民所信任的、被人民在长时间内考验过因此选中了的政治领导者。现在共产党说的话，比其他任何政党说的话，都易于为人民所接受。没有中国共产党在过去十五年间的艰苦奋斗，挽救新的亡国危险是不可能的。   
　　中国共产党在革命战争中，除了犯过陈独秀右倾机会主义⑷和李立三“左”倾机会主义⑸两个错误之外，还犯过了下述的两个错误：其一，是在一九三一年至一九三四年的“左”倾机会主义⑹，这个错误使得土地革命战争受到了极端严重的损失，得到了在第五次反“围剿”中不能战胜敌人反而丧失了根据地削弱了红军的结果。这个错误是在一九三五年一月扩大的中央政治局的遵义会议⑺时纠正过来了。其二，是在一九三五年至一九三六年的张国焘右倾机会主义⑻，这个错误发展到破坏了党和红军的纪律，使一部分红军主力遭受了严重的损失；然而由于中央的正确领导，红军中党员和指挥员战斗员的觉悟，终于也把这个错误纠正过来了。所有这些错误，对于我们的党，我们的革命和战争，当然是不利的，然而终于被我们克服，我们的党和我们的红军是从这些错误的克服中锻炼得更加坚强了。   
　　中国共产党领导了、而且继续领导着轰轰烈烈的光荣的胜利的革命战争。这个战争不但是解放中国的旗帜，而且是具有国际的革命意义的。世界的革命人民的眼睛都望着我们。在新的抗日民族革命战争的阶段上，我们将引导中国革命走向完成，也将给东方和世界的革命以深刻的影响。过去的革命战争证明，我们不但需要一个马克思主义的正确的政治路线，而且需要一个马克思主义的正确的军事路线。十五年的革命和战争，已经锻炼出来这样一条政治的和军事的路线了。今后战争的新阶段，我们相信，将使这样的路线，根据新的环境，更加发展、充实和丰富起来，达到战胜民族敌人之目的。历史告诉我们，正确的政治的和军事的路线，不是自然地平安地产生和发展起来的，而是从斗争中产生和发展起来的。一方面，它要同“左”倾机会主义作斗争，另一方面，它又要同右倾机会主义作斗争。不同这些危害革命和革命战争的有害的倾向作斗争，并且彻底地克服它们，正确路线的建设和革命战争的胜利，是不可能的。我在这本小册子中时常提到错误方面的意见，就是为了这个目的。   
## 第三章　中国革命战争的特点  

### 第一节　这个问题的重要性  

  
　　不承认、不知道、或不愿意知道中国革命战争有其特点的人，把红军对国民党军队的作战，看做和一般战争相同，或和苏联内战相同。列宁斯大林领导的苏联内战的经验是有世界的意义的。所有的共产党，中国共产党也同样，都是以这个经验和列宁斯大林对这个经验的理论综合作为指南的。但这并不是说，我们应该在我们的条件下机械地运用这个经验。中国革命战争的许多方面都有其自己的不同于苏联内战的特点。不估计到这种特点，或否认这种特点，当然是错误的。这点在我们的十年战争中已经完全证明了。   
　　我们的敌人也曾犯过类似的错误。他们不承认和红军作战需要有和其他作战不同的战略和战术。他们依仗其各方面的优势，轻视我们，固守其老一套的战法。这是一九三三年敌人的第四次“围剿”时期及其以前的情形，其结果就是招致了他们的历次的失败。首先在国民党军队中提出在这个问题上的新意见的是国民党的反动将军柳维垣，后来有戴岳。最后他们的意见被蒋介石采纳了。这就是蒋介石庐山军官训练团⑼及其在第五次“围剿”中施行的反动的新军事原则⑽产生的过程。   
　　然而当着敌人改变其军事原则使之适合于同红军作战的情况的时候，我们队伍中却出现了回到“老套”的人们。他们主张回到一般情况的方面去，拒绝了解任何的特殊情况，拒绝红军血战史的经验，轻视帝国主义和国民党的力量，轻视国民党军队的力量，对敌人采用的反动的新原则视若无睹。结果，是丧失了除了陕甘边区以外的一切革命根据地，使红军由三十万人降到了几万人，使中国共产党由三十万党员降到了几万党员，而在国民党区域的党组织几乎全部丧失。总之，是受了一次极大的历史性的惩罚。他们自称为马克思列宁主义者，其实一点马克思列宁主义也没有学到。列宁说：马克思主义的最本质的东西，马克思主义的活的灵魂，就在于具体地分析具体的情况⑾。我们的这些同志恰是忘记了这一点。   
　　由此可知，不了解中国革命战争的特点，就不能指导中国革命战争，就不能引导中国革命战争走上胜利的途径。   
### 第二节　中国革命战争的特点是什么  

  
　　那末，中国革命战争的特点是什么呢？   
　　我以为有四个主要的特点。   
　　第一个特点，中国是一个政治经济发展不平衡的半殖民地的大国，而又经过了一九二四年至一九二七年的革命。   
　　这个特点，指出中国革命战争有发展和胜利的可能性。当着一九二七年冬天至一九二八年春天，中国游击战争发生不久，湖南江西两省边界区域——井冈山的同志们中有些人提出“红旗到底打得多久”这个疑问的时候，我们就把它指出来了（湘赣边界党的第一次代表大会⑿）。因为这是一个最基本的问题，不答复中国革命根据地和中国红军能否存在和发展的问题，我们就不能前进一步。一九二八年中国共产党第六次全国代表大会⒀，把这个问题又作了一次答复。中国革命运动，从此就有了正确的理论基础。   
　　现在把这个问题分开来看一看：   
　　中国政治经济发展不平衡——微弱的资本主义经济和严重的半封建经济同时存在，近代式的若干工商业都市和停滞着的广大农村同时存在，几百万产业工人和几万万旧制度统治下的农民和手工业工人同时存在，管理中央政府的大军阀和管理各省的小军阀同时存在，反动军队中有隶属蒋介石的所谓中央军和隶属各省军阀的所谓杂牌军这样两部分军队同时存在，若干的铁路航路汽车路和普遍的独轮车路、只能用脚走的路和用脚还不好走的路同时存在。   
　　中国是一个半殖民地国家——帝国主义的不统一，影响到中国统治集团间的不统一。数国支配的半殖民地国家和一国支配的殖民地是有区别的。   
　　中国是一个大国——“东方不亮西方亮，黑了南方有北方”，不愁没有回旋的余地。   
　　中国是经过了一次大革命的——准备好了红军的种子，准备好了红军的领导者即共产党，又准备好了参加过一次革命的民众。   
　　所以我们说，中国是一个经过了一次革命的、政治经济发展不平衡的、半殖民地的大国，这是中国革命战争的第一个特点。这个特点，不但基本地规定了我们政治上的战略和战术，而且也基本地规定了我们军事上的战略和战术。   
　　第二个特点是敌人的强大。   
　　红军的敌人国民党，它的情况是怎样呢？它是夺取了政权而且相对地稳定了它的政权的党。它得到了全世界主要反革命国家的援助。它已改造了它的军队——改造得和中国任何一个历史时代的军队都不相同，而和世界现代国家的军队却大体相同，武器和其他军事物资的供给比起红军来雄厚得多，而且其军队数量之多超过中国任何一个历史时代的军队，超过世界任何一个国家的常备军。它的军队和红军比较起来真有天壤之别。它控制了全中国的政治、经济、交通、文化的枢纽或命脉，它的政权是全国性的政权。   
　　中国红军是处在这样强大的敌人的面前。这是中国革命战争的第二个特点。这个特点，使红军的作战不能不和一般战争以及苏联内战、北伐战争都有许多的不同。   
　　第三个特点是红军的弱小。   
　　中国红军是产生于第一次大革命失败之后，从游击队开始。不但处在中国的反动时期，而且处在世界上反动的资本主义国家在政治上经济上比较稳定的时期。   
　　我们的政权是分散而又孤立的山地或僻地的政权，没有任何的外间援助。革命根据地的经济条件和文化条件同国民党区域比较是落后的。革命根据地只有乡村和小城市。其区域开始是非常之小，后来也并不很大。而且根据地是流动不定的；红军没有真正巩固的根据地。   
　　红军的数量是少的，红军的武器是差的，红军的粮食被服等物质供给是非常困难的。   
　　这个特点和前一个特点是尖锐的对比。红军的战略战术，是在这种尖锐的对比上发生的。   
　　第四个特点是共产党的领导和土地革命。   
　　这个特点是第一个特点的必然结果。这个特点产生了两方面的情形。在一方面，中国革命战争虽然是处在中国和资本主义世界的反动时期，然而是能够胜利的，因为它有共产党的领导和农民的援助。根据地虽小却有很大的政治上的威力，屹然和庞大的国民党政权相对立，军事上给国民党的进攻以很大的困难，因为我们有农民的援助。红军虽小却有强大的战斗力，因为在共产党领导下的红军人员是从土地革命中产生，为着自己的利益而战斗的，而且指挥员和战斗员之间在政治上是一致的。   
　　另一方面，则和国民党成了尖锐的对比。国民党是反对土地革命的，因此没有农民的援助。其军队虽多，却不能使兵士群众和许多小生产者出身的下级干部自觉地为国民党拚命，官兵之间在政治上是分歧的，这就减少了它的战斗力。   
### 第三节　由此产生我们的战略战术  

  
　　经过了一次大革命的政治经济不平衡的半殖民地的大国，强大的敌人，弱小的红军，土地革命——这是中国革命战争四个主要的特点。这些特点，规定了中国革命战争的指导路线及其许多战略战术的原则。第一个特点和第四个特点，规定了中国红军的可能发展和可能战胜其敌人。第二个特点和第三个特点，规定了中国红军的不可能很快发展和不可能很快战胜其敌人，即是规定了战争的持久，而且如果弄得不好的话，还可能失败。   
　　这就是中国革命战争的两方面。这两方面同时存在着，即是说，既有顺利的条件，又有困难的条件。这是中国革命战争的根本规律，许多规律都是从这个根本的规律发生出来的。我们的十年战争史证明了这个规律的正确性。谁要是睁眼看不见这些根本性质的规律，谁就不能指导中国的革命战争，谁就不能使红军打胜仗。   
　　很明显的，正确地规定战略方向，进攻时反对冒险主义，防御时反对保守主义，转移时反对逃跑主义；反对红军的游击主义，却又承认红军的游击性；反对战役的持久战和战略的速决战，承认战略的持久战和战役的速决战；反对固定的作战线和阵地战，承认非固定的作战线和运动战；反对击溃战，承认歼灭战；反对战略方向的两个拳头主义，承认一个拳头主义；反对大后方制度，承认小后方制度；反对绝对的集中指挥，承认相对的集中指挥；反对单纯军事观点和流寇主义⒁，承认红军是中国革命的宣传者和组织者；反对土匪主义⒂，承认严肃的政治纪律；反对军阀主义，承认有限制的民主生活和有威权的军事纪律；反对不正确的宗派主义的干部政策，承认正确的干部政策；反对孤立政策，承认争取一切可能的同盟者；最后，反对把红军停顿于旧阶段，争取红军发展到新阶段——所有这些原则问题，都要求正确的解决。我们现在要讲的战略问题，就是要就中国革命战争的十年血战史的经验，好好地说明这些问题。   
## 第四章　“围剿”和反“围剿”——中国内战的主要形式  

  
　　十年以来，从游击战争开始的一天起，任何一个独立的红色游击队或红军的周围，任何一个革命根据地的周围，经常遇到的是敌人的“围剿”。敌人把红军看作异物，一出现就想把它捕获。敌人总是跟着红军，而且总是把它围起来。这种形式，过去十年是没有变化的，如果没有民族战争代替国内战争，那末，直到敌人变成弱小者、红军变成强大者那一天为止，这种形式也是不会变化的。   
　　红军的活动，采取了反“围剿”的形式。所谓胜利，主要地是说反“围剿”的胜利，这就是战略和战役的胜利。反对一次“围剿”是一个战役，常常由大小数个以至数十个战斗组织而成。在一次“围剿”没有基本地打破以前，即使得到了许多战斗的胜利，还不能说战略上或整个战役上已经胜利了。十年的红军战争史，就是一部反“围剿”史。   
　　敌人的“围剿”和红军的反“围剿”，互相采用进攻和防御这两种战斗的形式，这是和古今中外的战争没有两样的。然而中国内战的特点，则在二者的长期的反复。在一次“围剿”中，敌人以进攻反对红军的防御，红军以防御反对敌人的进攻，这是反“围剿”战役的第一个阶段。敌人以防御反对红军的进攻，红军以进攻反对敌人的防御，这是反“围剿”战役的第二个阶段。任何的“围剿”，都是包括这两个阶段的，而且是长期地反复的。   
　　说长期反复，是说战争和战斗形式的反复。这是事实，任何人一看就知的。“围剿”和反“围剿”，是战争形式的反复。敌以进攻对我防御、我以防御对敌进攻的第一阶段，和敌以防御对我进攻、我以进攻对敌防御的第二阶段，是每一次“围剿”中战斗形式的反复。   
　　至于战争和战斗的内容，则不是简单地反复的，而是每次不同的。这也是事实，任何人一看就知的。这里的规律，是“围剿”和反“围剿”的规模一次比一次大，情况一次比一次复杂，战斗一次比一次激烈。   
　　然而不是没有起落的。第五次“围剿”之后，因为红军极大地削弱了，南方根据地全部丧失，红军移到了西北，不是如同在南方那样处在威胁国内敌人的最重要的地位了，“围剿”的规模、情况和战斗，就比较小些，简单些，缓和些了。   
　　红军的失败是什么呢？在战略上说，只有反“围剿”根本没有成功，才叫做失败，而且也只能叫做局部的和暂时的失败。因为国内战争的根本的失败，就是整个红军的覆灭，然而这样的事实是没有的。广大根据地的丧失和红军的转移，这是暂时的和局部的失败，不是永远的和全部的失败，虽然这个局部是包括了党和军队和根据地的百分之九十。这种事实，我们把它叫做防御的继续，而把敌人的追击叫做进攻的继续。这就是说，在“围剿”和反“围剿”的斗争中，我们没有由防御转到进攻，反而被敌人的进攻打破了我们的防御，我们的防御就变成了退却，敌人的进攻就变成了追击。然而等到红军到达一个新的地区时，例如我们由江西等地移到了陕西，“围剿”的反复又出现了。所以我们说，红军的战略退却（长征）是红军的战略防御的继续，敌人的战略追击是敌人的战略进攻的继续。   
　　中国国内战争和任何古今中外的战争一样，基本的战斗形式只有攻防两种。中国内战的特点，是“围剿”和反“围剿”的长期地反复和攻防两种战斗形式的长期地反复，并且包括着一次一万多公里的伟大的战略转移（长征）⒃这样一种东西在里面。   
　　所谓敌人的失败，也是如此。他们的战略失败，就是他们的“围剿”被我们打破，我们的防御变成了进攻，敌人转到防御地位，必须重新组织才有再一次的“围剿”。敌人没有如同我们所谓一万多公里的战略转移的那种情形，这是因为他们是全国性的统治者，他们比我们强大得多的缘故。然而部分的事情是有过的。若干根据地中被红军围攻的白色据点内的敌人突围而出，退却到白区里去重新组织进攻，这样的事是发生过的。如果内战延长，红军胜利的范围更广大时，这种事情会多起来。但是他们的结果不能和红军相比，因为他们没有人民的援助，官兵之间又不一致。他们如果也学红军的长途转移，那是一定会被消灭的。   
　　在一九三〇年的立三路线时期，李立三同志不懂得中国内战的持久性，因此看不出中国内战发展中“围剿”又“围剿”、打破又打破的这种长期反复的规律（那时已有湘赣边界的三次“围剿”⒄，福建的两次“围剿”⒅等），因此在红军还幼小的时代就命令红军去打武汉，命令全国举行武装起义，企图使全国革命迅速胜利。这就犯了“左”倾机会主义的错误。   
　　一九三一年至一九三四年的“左”倾机会主义，也不相信“围剿”反复这一规律。在鄂豫皖边区根据地则有所谓“偏师”⒆说，那里的一些领导同志认为第三次“围剿”⒇失败后的国民党不过是偏师了，要进攻红军，就得由帝国主义亲身出马担当主力军。在这个估计之下的战略方针，就是红军打武汉。这和江西的一些同志号召红军打南昌，反对进行使各根据地联成一片的工作，反对诱敌深入的作战，把一省胜利放在夺取省城和中心城市的基点上，以及认为“反对五次‘围剿’是革命道路和殖民地道路的决战”等等，是在原则上一致的。这个“左”倾机会主义，种下了鄂豫皖边区反对第四次“围剿”（21）、江西中央区反对第五次“围剿”斗争中的错误路线的根苗，使红军在敌人的严重的“围剿”面前不得不处于无能的地位，给了中国革命以很大的损失。   
　　跟否认“围剿”反复的“左”倾机会主义直接联系，而说红军根本不应该采取防御手段的一种意见，也是完全不正确的。   
　　革命和革命战争是进攻的——这种说法当然有它的正确性。革命和革命战争从发生到发展，从小到大，从没有政权到夺取政权，从没有红军到创造红军，从没有革命根据地到创造革命根据地，总是要进攻的，是不能保守的，保守主义的倾向是应该反对的。   
　　革命和革命战争是进攻的，但是也有防御和后退——这种说法才是完全正确的。为了进攻而防御，为了前进而后退，为了向正面而向侧面，为了走直路而走弯路，是许多事物在发展过程中所不可避免的现象，何况军事运动。   
　　上述两个论断中的前一论断，在政治上说来可以是对的，移到军事上就不对了。在政治上，也只是在某一种情况说来（革命前进时）是对的，移到另一种情况（革命退却时：全部退却，例如俄国在一九〇六年（22）、中国在一九二七年；局部退却，例如俄国在一九一八年的布列斯特条约（23）时）也就不对了。只有后一论断，才是全部地正确的真理。一九三一年至一九三四年的“左”倾机会主义，机械地反对使用军事防御的手段，不过是一种非常幼稚的思想。   
　　“围剿”反复的形式何时结束？据我看来，如果内战延长的话，那是在敌我强弱对比起了根本变化之时。如果红军一旦改变到比自己的敌人更为强大时，那末，这个反复就结束了。那时是我们围剿敌人，敌人则企图反围剿，但是政治和军事的条件将不允许敌人获得如同红军一样的反“围剿”的地位。那时，“围剿”反复这种形式，即使不说完全结束，但是一般的结束是可以断言的。   
## 第五章　战略防御  

  
　　这个题目中，我想说明下列各问题：（一）积极防御和消极防御；（二）反“围剿”的准备；（三）战略退却；（四）战略反攻；（五）反攻开始问题；（六）集中兵力问题；（七）运动战；（八）速决战；（九）歼灭战。   
### 第一节　积极防御和消极防御  

  
　　为什么从防御说起呢？一九二四年至一九二七年的中国第一次民族统一战线失败后，革命成了极深刻极残酷的阶级战争。敌人是全国的统治者，我们只有一点小部队，因此，我们一开始就是和敌人的“围剿”奋斗。我们的进攻是密切地联系于打破“围剿”的，我们发展的命运全看我们能不能打破“围剿”。打破“围剿”的过程往往是迂回曲折的，不是径情直遂的。首先而且严重的问题，是如何保存力量，待机破敌。所以，战略防御问题成为红军作战中最复杂和最重要的问题。   
　　在我们的十年战争中，对于战略防御问题，常常发生两种偏向，一种是轻视敌人，又一种是为敌人所吓倒。   
　　由于轻视敌人，许多游击队失败了，红军对若干次敌人的“围剿”不能打破。   
　　革命的游击队初起，领导者对于敌我形势往往看得不正确。他们看见自己在一个地方用突然的武装起义胜利了，或从白军中哗变出来了，一时的环境很顺利，或者虽有严重的环境而看不到，因此往往轻视敌人。另一方面，对自己的弱点（没有经验，力量弱小），也不了解。敌强我弱，原是客观地存在的现象，可是人们不愿意想一想，一味只讲进攻，不讲防御和退却，在精神上解除了防御的武装，因而把行动引到错误的方向。许多游击队因此失败了。   
　　红军因为和这同样的原因不能打破“围剿”的例子，则有一九二八年广东海陆丰区域的红军的失败（24），以及一九三二年鄂豫皖边区的红军，在所谓国民党偏师说的指导之下，使得反对第四次“围剿”丧失了措置裕如的能力的事实。   
　　为敌人吓倒而受挫折的例子，是很多的。   
　　和轻敌者相反，人们太看重了敌人，太看轻了自己，因而采取了非必要的退却方针，精神上同样地解除了防御的武装。其结果或者是游击队失败，或者是红军的某些战役失败，或者是根据地丧失。   
　　丧失根据地的最显著的例子，是在反对第五次“围剿”中丧失了江西中央根据地。这里的错误是从右倾的观点产生的。领导者们畏敌如虎，处处设防，节节抵御，不敢举行本来有利的向敌人后方打去的进攻，也不敢大胆放手诱敌深入，聚而歼之，结果丧失了整个根据地，使红军做了一万二千多公里的长征。然而这种错误，往往有一种“左”倾轻敌的错误为之先行。一九三二年进攻中心城市的军事冒险主义，正是后来在对付敌人第五次“围剿”中采取消极防御路线的根源。   
　　为敌人吓倒的极端的例子，是退却主义的“张国焘路线”。红军第四方面军的西路军在黄河以西的失败（25），是这个路线的最后的破产。   
　　积极防御，又叫攻势防御，又叫决战防御。消极防御，又叫专守防御，又叫单纯防御。消极防御实际上是假防御，只有积极防御才是真防御，才是为了反攻和进攻的防御。据我所知，任何一本有价值的军事书，任何一个比较聪明的军事家，而且无论古今中外，无论战略战术，没有不反对消极防御的。只有最愚蠢的人，或者最狂妄的人，才捧了消极防御当法宝。然而世上偏有这样的人，做出这样的事。这是战争中的过失，是保守主义在军事上的表现，我们应该坚决地反对它。   
　　后起而且发展得很快的帝国主义国家，即德日两国的军事家中，积极地鼓吹战略进攻的利益，反对战略防御。这种思想，是根本不合于中国革命战争的。德日帝国主义的军事家们指出防御的一个重要的弱点是不能振奋人心，反而使人心动摇。这是说的阶级矛盾剧烈，而战争的利益仅仅属于反动的统治阶层乃至反动的当权政派的那种国家。我们的情况不同。在保卫革命根据地和保卫中国的口号下，我们能够团结最大多数人民万众一心地作战，因为我们是被压迫者和被侵略者。苏联内战时期的红军也是在防御形式之下战胜敌人的。他们的战争不但在帝国主义各国组织白党进攻时，是在保卫苏维埃的口号下进行的，就是在十月起义的准备时期，也是在保卫首都的口号下进行军事动员的。一切正义战争的防御战，不但有麻痹政治上异己分子的作用，而且可以动员落后的人民群众加入到战争中来。   
　　马克思说的武装起义之后一刻也不应该停止进攻（26），这是说乘敌不备而突然起义的群众，应该不让反动的统治者有保守政权或恢复政权的机会，趁此一瞬间把国内反动的统治势力打个措手不及，而不要满足于已得的胜利，轻视敌人，放松对于敌人的进攻，或者畏缩不前，坐失消灭敌人的时机，招致革命的失败。这是正确的。然而不是说，敌我双方已在军事对抗中，而且敌人是优势，当受敌人压迫时，革命党人也不应该采取防御手段。如果这样想，那就是第一号的傻子。   
　　我们过去的战争，整个地说来是向国民党进攻，然而在军事上采取了打破“围剿”的形式。   
　　在军事上说来，我们的战争是防御和进攻的交替的应用。对于我们，说进攻是在防御之后，或说进攻是在防御之前都是可以的，因为关键在于打破“围剿”。“围剿”没有打破以前是防御，“围剿”一经打破就开始了进攻，仅仅是一件事情的两个阶段，而敌人的一次“围剿”和它的又一次“围剿”是衔接着的。这两个阶段中，防御的阶段比进攻的阶段更为复杂，更为重要。这个阶段包含着怎样打破“围剿”的许多问题。基本的原则是承认积极防御，反对消极防御。   
　　从国内战争说，假如红军的力量超过了敌人时，那末，一般地就用不着战略防御了。那时的方针只是战略的进攻。这种改变，依靠于敌我力量的总的变动。到了那时，剩下的防御手段，只是局部的东西了。   
### 第二节　反“围剿”的准备  

  
　　对于敌人的一次有计划的“围剿”，如果我们没有必要的和充分的准备，必然陷入被动地位。临时仓卒应战，胜利的把握是没有的。因此，在和敌人准备“围剿”同时，进行我们的反“围剿”的准备，实有完全的必要。我们队伍中曾经发生过的反对准备的意见是幼稚可笑的。   
　　这里有一个困难问题，容易发生争论。就是，何时结束自己的进攻，转入反“围剿”的准备阶段呢？因为当自己处在胜利的进攻中，敌人处在防御地位时，敌人的“围剿”准备是在秘密地进行的，我们难于知道他们将在何时开始进攻。我们准备反“围剿”的工作开始早了，不免减少进攻的利益，而且有时会给予红军和人民以若干不良的影响。因为准备阶段中的主要步骤，就是军事上的准备退却，和为着准备退却的政治上的动员。有时准备过早，会变为等待敌人；等了好久而敌人未来，不得不重新发动自己的进攻。有时我们的重新进攻刚在开始，又恰好遇到了敌人进攻的开始，把自己处在困难地位。所以开始准备的时机的选择，成为一个重要问题。断定这种时机，要从敌我双方情况和二者间的关系着眼。为着了解敌人的情况，须从敌人方面的政治、军事、财政和社会舆论等方面搜集材料。分析这些材料的时候，要足够地估计敌人的整个力量，不可夸大敌人过去失败的程度，但也决不可不估计到敌人内部的矛盾，财政的困难，过去失败的影响等等。对自己方面，不可夸大过去胜利的程度，但也决不可不足够地估计到过去胜利的影响。   
　　但是开始准备的时机问题，一般地说来，与其失之过迟，不如失之过早。因为后者的损失较之前者为小，而其利益，则是有备无患，根本上立于不败之地。   
　　准备阶段中的主要的问题，是红军的准备退却，政治动员，征集新兵，财政和粮食的准备，政治异己分子的处置等。   
　　所谓红军的准备退却，就是说不要使红军向着不利于退却的方向，不要进攻得太远了，不要使红军过于疲劳。这是在敌人大举进攻的前夜主力红军的必要的处置。这时红军的注意力，主要地要放在创造战场，征集资材，扩大自己和训练自己的计划上。   
　　政治动员是反“围剿”斗争中第一个重要问题。这即是说，明确、坚决而充分地告诉红军人员和根据地的人民，关于敌人进攻的必然性和迫切性，敌人进攻危害人民的严重性，同时，关于敌人的弱点，红军的优良条件，我们一定要胜利的志愿，我们工作的方向等。号召红军和人民全体为反对“围剿”、保卫根据地而斗争。除开军事秘密外，政治动员是必须公开的，而且力求普及于每一个可能拥护革命利益的人员。重要的关节是说服干部。   
　　征集新兵须从两方面出发：一方面顾到人民的政治觉悟程度和人口情况；又一方面顾到当时红军的情况和整个反“围剿”战役中红军消耗的可能限度。   
　　财政和粮食问题，不待说对于反对“围剿”是有重大意义的。要顾及“围剿”时间的可能延长。应当计算，主要的是红军，再则革命根据地的人民，在整个反“围剿”斗争中物资需要的最低限度。   
　　对待政治异己分子，不可对他们不警戒；但也不可过于恐惧他们的叛变，而采取过分的警戒手段。对地主、商人、富农之间是应该有分别的，主要地是政治上向他们说明，争取他们中立，并且组织民众监视他们。只有对极少数最带危险性的分子，才可以采用严峻手段，例如逮捕等。   
　　反“围剿”斗争胜利的程度，是和准备阶段中任务完成的程度密切地联系着的。由轻敌而发生的对于准备的放松，和由被敌人进攻所吓倒而发生的惊惶失措，都是应该坚决反对的不良倾向。我们需要的是热烈而镇定的情绪，紧张而有秩序的工作。   
### 第三节　战略退却  

  
　　战略退却，是劣势军队处在优势军队进攻面前，因为顾到不能迅速地击破其进攻，为了保存军力，待机破敌，而采取的一个有计划的战略步骤。可是，军事冒险主义者则坚决反对此种步骤，他们的主张是所谓“御敌于国门之外”。   
　　谁人不知，两个拳师放对，聪明的拳师往往退让一步，而蠢人则其势汹汹，辟头就使出全副本领，结果却往往被退让者打倒。   
　　《水浒传》上的洪教头，在柴进家中要打林冲，连唤几个“来”“来”“来”，结果是退让的林冲看出洪教头的破绽，一脚踢翻了洪教头（27）。   
　　春秋时候，鲁与齐（28）战，鲁庄公起初不待齐军疲惫就要出战，后来被曹刿阻止了，采取了“敌疲我打”的方针，打胜了齐军，造成了中国战史中弱军战胜强军的有名的战例。请看历史家左丘明（29）的叙述：   
  
　　“春，齐师伐我。公将战。曹刿请见。其乡人曰：肉食者谋之，又何间焉？刿曰：肉食者鄙，未能远谋。乃入见。问：何以战？公曰：衣食所安，弗敢专也，必以分人。对曰：小惠未遍，民弗从也。公曰：牺牲玉帛，弗敢加也，必以信。对曰：小信未孚，神弗福也。公曰：小大之狱，虽不能察，必以情。对曰：忠之属也。可以一战。战则请从。公与之乘。战于长勺。公将鼓之。刿曰：未可。齐人三鼓。刿曰：可矣。齐师败绩。公将驰之。刿曰：未可。下视其辙，登轼而望之，曰：可矣。遂逐齐师。既克，公问其故。对曰：夫战，勇气也。一鼓作气，再而衰，三而竭。彼竭我盈，故克之。夫大国难测也，惧有伏焉。吾视其辙乱，望其旗靡，故逐之。”（30）   
  
　　当时的情况是弱国抵抗强国。文中指出了战前的政治准备——取信于民，叙述了利于转入反攻的阵地——长勺，叙述了利于开始反攻的时机——彼竭我盈之时，叙述了追击开始的时机——辙乱旗靡之时。虽然是一个不大的战役，却同时是说的战略防御的原则。中国战史中合此原则而取胜的实例是非常之多的。楚汉成皋之战（31）、新汉昆阳之战（32）、袁曹官渡之战（33）、吴魏赤壁之战（34）、吴蜀彝陵之战（35）、秦晋淝水之战（36）等等有名的大战，都是双方强弱不同，弱者先让一步，后发制人，因而战胜的。   
　　我们的战争是从一九二七年秋天开始的，当时根本没有经验。南昌起义（37）、广州起义（38）是失败了，秋收起义（39）在湘鄂赣边界地区的部队，也打了几个败仗，转移到湘赣边界的井冈山地区。第二年四月，南昌起义失败后保存的部队，经过湘南也转到了井冈山。然而从一九二八年五月开始，适应当时情况的带着朴素性质的游击战争基本原则，已经产生出来了，那就是所谓“敌进我退，敌驻我扰，敌疲我打，敌退我追”的十六字诀。这个十六字诀的军事原则，立三路线以前的中央是承认了的。后来我们的作战原则有了进一步的发展。到了江西根据地第一次反“围剿”时，“诱敌深入”的方针提出来了，而且应用成功了。等到战胜敌人的第三次“围剿”，于是全部红军作战的原则就形成了。这时是军事原则的新发展阶段，内容大大丰富起来，形式也有了许多改变，主要地是超越了从前的朴素性，然而基本的原则，仍然是那个十六字诀。十六字诀包举了反“围剿”的基本原则，包举了战略防御和战略进攻的两个阶段，在防御时又包举了战略退却和战略反攻的两个阶段。后来的东西只是它的发展罢了。   
　　然而从一九三二年一月开始，在党的“三次‘围剿’被粉碎后争取一省数省首先胜利”那个包含着严重原则错误的决议发布之后，“左”倾机会主义者就向着正确的原则作斗争，最后是撤消了一套正确原则，成立了另一整套和这相反的所谓“新原则”，或“正规原则”。从此以后，从前的东西不能叫做正规的了，那是应该否定的“游击主义”。反“游击主义”的空气，统治了整整的三个年头。其第一阶段是军事冒险主义，第二阶段转到军事保守主义，最后，第三阶段，变成了逃跑主义。直到党中央一九三五年一月在贵州的遵义召开扩大的政治局会议的时候，才宣告这个错误路线的破产，重新承认过去路线的正确性。这是费了何等大的代价才得来的啊！   
　　起劲地反对“游击主义”的同志们说：诱敌深入是不对的，放弃了许多地方。过去虽然打过胜仗，然而现在不是已经和过去不同了吗？并且不放弃土地又能打胜敌人不是更好些吗？在敌区或在我区敌区交界地方去打胜敌人不是更好些吗？过去的东西没有任何的正规性，只是游击队使用的办法。现在我们的国家已成立了，我们的红军已正规化了。我们和蒋介石作战是国家和国家作战，大军和大军作战。历史不应重复，“游击主义”的东西是应该全部抛弃的了。新的原则是“完全马克思主义”的，过去的东西是游击队在山里产生的，而山里是没有马克思主义的。新原则和这相反：“以一当十，以十当百，勇猛果敢，乘胜直追”，“全线出击”，“夺取中心城市”，“两个拳头打人”。敌人进攻时，对付的办法是“御敌于国门之外”，“先发制人”，“不打烂坛坛罐罐”，“不丧失寸土”，“六路分兵”；是“革命道路和殖民地道路的决战”；是短促突击，是堡垒战，是消耗战，是“持久战”；是大后方主义，是绝对的集中指挥；最后，则是大规模搬家。并且谁不承认这些，就给以惩办，加之以机会主义的头衔，如此等等。   
　　无疑地，这全部的理论和实际都是错了的。这是主观主义。这是环境顺利时小资产阶级的革命狂热和革命急性病的表现；环境困难时，则依照情况的变化以次变为拚命主义、保守主义和逃跑主义。这是鲁莽家和门外汉的理论和实际，是丝毫也没有马克思主义气味的东西，是反马克思主义的东西。   
　　这里单说战略退却，江西叫做“诱敌深入”，四川叫做“收紧阵地”。从前的军事理论家和实际家也无不承认这是弱军对强军作战时在战争开始阶段必须采取的方针。外国的军事家就曾这样说：“战略守势的作战，大都先避不利的决战，使至有利的情况始求决战。”这是完全正确的，我们对此也没有任何的增加。   
　　战略退却的目的是为了保存军力，准备反攻。退却之所以必要，是因为处在强敌的进攻面前，若不退让一步，则必危及军力的保存。过去却有许多人坚决地反对退却，认为这是“机会主义的单纯防御路线”。我们的历史已经证明这个反对是完全错误的了。   
　　准备反攻，须选择和造成有利于我不利于敌的若干条件，使敌我力量对比发生变化，然后进入反攻阶段。   
　　依我们的过去情形说来，大概须在退却阶段中取得下列诸种条件中至少二种以上，才算是有利于我不利于敌，才好使自己转入反攻。这些条件是：   
　　（一）积极援助红军的人民；   
　　（二）有利作战的阵地；   
　　（三）红军主力的全部集中；   
　　（四）发现敌人的薄弱部分；   
　　（五）使敌人疲劳沮丧；   
　　（六）使敌人发生过失。   
　　人民这个条件，对于红军是最重要的条件。这就是根据地的条件。并且由于这个条件，第四、第五、第六等条件也容易造成或发现。所以当敌人大举进攻红军时，红军总是从白区退却到根据地来，因为根据地的人民是最积极地援助红军反对白军的。根据地的边缘区和中心区，也有区别；对于封锁消息、侦察、运输、参战等事，中心区的人民比较边缘区为好。所以“退却终点”，在过去江西反对第一、二、三次“围剿”时，都选在人民条件最好或较好的地区。根据地这个特点，使红军的作战比较一般的作战起了很大的变化，也是使后来敌人不得不采取堡垒主义（40）的主要原因。   
　　退却的军队能够选择自己所欲的有利阵地，使进攻的军队不得不就我范围，这是内线作战的一个优良条件。弱军要战胜强军，是不能不讲求阵地这个条件的。但是单有这个条件还不够，还要求别的条件和它配合。首先是人民的条件。再则还要求好打的敌人，例如敌人疲劳了，或者发生了过失，或者该路前进的敌人比较地缺乏战斗力。这些条件不具备时，虽有优良阵地，也只得置之不顾，继续退却，以就自己所欲的条件。白区未尝无优良的阵地，但无优良的人民条件。如果其他条件也还未造成或未发现时，红军便不得不向根据地退却。根据地的边缘区和中心区的分别，也大体是如此。   
　　除地方部队和钳制兵力外，一切突击兵力以全部集中为原则。当着我们向战略上取守势的敌人进攻时，红军往往是分散的。一旦敌人大举向我进攻，红军就实行所谓“求心退却”。退却的终点，往往选在根据地中部；但有时也在前部，有时则在后部，依照情况来决定。这种求心退却，能够使全部红军主力完全集中起来。   
　　弱军对于强军作战的再一个必要条件，就是拣弱的打。然而当敌人开始进攻时，我们往往不知敌之分进各军何部最强，何部次强，何部最弱，何部次弱，需要一个侦察的过程。往往需要许多时间，才能达此目的。战略退却的所以必要，这也是一个理由。   
　　如果进攻之敌在数量和强度上都超过我军甚远，我们要求强弱的对比发生变化，便只有等到敌人深入根据地，吃尽根据地的苦楚，如同第三次“围剿”时蒋介石某旅参谋长所说的“肥的拖瘦，瘦的拖死”，又如“围剿”军西路总司令陈铭枢所说的“国军处处黑暗，红军处处明亮”之时，才能达到目的。这种时候，敌军虽强，也大大减弱了；兵力疲劳，士气沮丧，许多弱点都暴露出来。红军虽弱，却养精蓄锐，以逸待劳。此时双方对比，往往能达到某种程度的均衡，或者敌军的绝对优势改变到相对优势，我军的绝对劣势改变到相对劣势，甚至有敌军劣于我军，而我军反优于敌军的事情。江西反对第三次“围剿”时，红军实行了一种极端的退却（红军集中于根据地后部），然而非此是不能战胜敌人的，因为当时的“围剿”军超过红军十倍以上。孙子说的“避其锐气，击其惰归”（41），就是指的使敌疲劳沮丧，以求减杀其优势。   
　　退却的最后一个要求，是造成和发现敌人的过失。须知任何高明的敌军指挥员，在相当长时间中，要不发生一点过失，是不可能的，因此我们乘敌之隙的可能性，总是存在的。敌人会犯错误，正如我们自己有时也弄错，有时也授敌以可乘之隙一样。而且我们可以人工地造成敌军的过失，例如孙子所谓“示形”之类（示形于东而击于西，即所谓声东击西）。要这样做，退却的终点，就不能限定于某一地区。有时退到该地区还无隙可乘，便不得不再退几步，待敌发生可乘之“隙”。   
　　退却所求的有利条件，大致如上所述。然而不是说，须待这些条件完全具备方能举行反攻。要同时具备这些条件是不可能的，而且也不必要。但依据敌人当前情势，争取若干必要条件，是以弱敌强的内线作战军队所应该注意的，在这上面的反对的意见是不正确的。   
　　决定退却终点究在何处，须以整个形势作出发点。在局部形势看来有利于我转入反攻，如果不是同时在全体形势看来也对我有利时，则据此决定退却终点，就是不正确的。因为反攻的开始，必须计算到以后的变化，而我们的反攻总是从局部开始的。有时退却终点应该选在根据地的前部，例如江西第二次、第四次反“围剿”，陕甘第三次反“围剿”时。有时须在根据地的中部，例如江西第一次反“围剿”时。有时则在根据地的后部，例如江西第三次反“围剿”时。这些都是将局部形势联系到整个形势来决定的。江西第五次反“围剿”，我军全然不讲退却，原因在于对局部形势和整个形势都不注意，实在是一种鲁莽灭裂的干法。形势是由条件造成的；观察局部形势和整个形势的联系，应从当时敌我双方所具条件之见于局部的和见于全体的，是否在一定的限度上利于我之开始反攻以为断。   
　　退却终点，在根据地可以大体上分为前部、中部、后部三种。然而是不是根本拒绝在白区作战呢？不是的。我们拒绝在白区作战，仅仅指的对付敌军大规模“围剿”。敌我强弱悬殊，我们在保存军力待机破敌的原则下，才主张向根据地退却，主张诱敌深入，因为只有这样做才能造成或发现利于反攻的条件。如果情况并不这样严重，或者情况的严重性简直使红军连在根据地也无法开始反攻，或者反攻不利需要再退以求局势之变化时，那末，把退却终点选在白区也是应该承认的，至少在理论上是应该承认的，虽然我们过去很少这种经验。   
　　白区退却终点大体上也可分为三种：第一是在根据地前面，第二在根据地侧面，第三在根据地后面。第一种终点，例如江西第一次反“围剿”时，如果红军没有内部不统一和地方党的分裂，即立三路线和AB团（42）两个困难问题存在，是可以设想在吉安、南丰、樟树三点之间集中兵力举行反攻的。因为当时从赣抚两河间（43）前进的敌人军力，比起红军来优势并不很大（十万对四万）。人民条件虽不如根据地，但阵地条件是有的，而且是可以乘敌分路前进时各个把他击破的。第二种终点，例如江西第三次反“围剿”时，假如当时敌人进攻的规模没有那样大，而敌有一路从闽赣交界的建宁、黎川、泰宁前进，这一路的力量又适合于我们的攻击时，也可以设想红军就在福建西部的白区集中，首先打破此敌，不必绕道千里走瑞金到兴国。第三种终点，同样例如上述江西第三次反“围剿”时，假如敌之主力不是向西而是向南，我们也许被迫着退到会昌、寻乌、安远地区（那里是白色区域），引敌更向南进，然后红军由南而北向根据地内部打去，这时北面根据地内部的敌军当不是很多的了。但以上这些说明都是假定，没有经验，可以作为特殊的东西看待，不可作一般原则看待。对于我们，当敌举行大规模“围剿”时，一般的原则是诱敌深入，是退却到根据地作战，因为这是使我们最有把握地打破敌人进攻的办法。   
　　主张“御敌于国门之外”的人们，反对战略退却，理由是退却丧失土地，危害人民（所谓“打烂坛坛罐罐”），对外也产生不良影响。在第五次反“围剿”中，则谓我退一步，敌之堡垒推进一步，根据地日蹙而无法恢复。如果说诱敌深入在以前是有用的，那末在堡垒主义的第五次“围剿”是无用的。对付第五次“围剿”，只能用分兵抵御和短促突击的方法。   
　　回答这些意见是容易的，我们的历史已经回答了。关于丧失土地的问题，常有这样的情形，就是只有丧失才能不丧失，这是“将欲取之必先与之”（44）的原则。如果我们丧失的是土地，而取得的是战胜敌人，加恢复土地，再加扩大土地，这是赚钱生意。市场交易，买者如果不丧失金钱，就不能取得货物；卖者如果不丧失货物，也不能取得金钱。革命运动所造成的丧失是破坏，而其取得是进步的建设。睡眠和休息丧失了时间，却取得了明天工作的精力。如果有什么蠢人，不知此理，拒绝睡觉，他明天就没有精神了，这是蚀本生意。我们在敌人第五次“围剿”时期的蚀本正因为这一点。不愿意丧失一部分土地，结果丧失了全部土地。阿比西尼亚（45）的打硬仗，也得到丧失全国的结果，虽然阿国失败的原因不仅仅这一点。   
　　危害人民的问题同此道理。不在一部分人民家中一时地打烂些坛坛罐罐，就要使全体人民长期地打烂坛坛罐罐。惧怕一时的不良的政治影响，就要以长期的不良影响做代价。十月革命后，俄国布尔什维克如果依照“左派共产主义者”的意见拒绝对德和约时，新生的苏维埃就有夭折的危险。   
　　这种看起来好像革命的“左”倾意见，来源于小资产阶级知识分子的革命急躁病，同时也来源于农民小生产者的局部保守性。他们看问题仅从一局部出发，没有能力通观全局，不愿把今天的利益和明天的利益相联结，把部分利益和全体利益相联结，捉住一局部一时间的东西死也不放。对的，一切依照当时具体情况看来对于当时的全局和全时期有利益的、尤其是有决定意义的一局部和一时间，是应该捉住不放的，不然我们就变成自流主义，或放任主义。退却要有终点，就是这个道理。然而这绝不能依靠小生产者的近视。我们应该学习的是布尔什维克的聪明。我们的眼力不够，应该借助于望远镜和显微镜。马克思主义的方法就是政治上军事上的望远镜和显微镜。   
　　当然，战略退却是有困难的。退却开始时机的选择，退却终点的选择，政治上对干部和人民的说服，都是困难问题，都必须给予解决。   
　　退却开始时机的问题是具有重要意义的。我们在江西第一次反“围剿”时的退却，如果不恰在那种时机，即是说如果再迟，那至少我们胜利的程度是要受到影响的。退却过早和过迟，当然都有损失。但是一般地说来，过迟的损失较之过早为大。及时退却，使自己完全立于主动地位，这对于到达退却终点以后，整顿队势，以逸待劳地转入反攻，有极大的影响。江西粉碎敌人第一次、第二次、第四次“围剿”的战役，都从容不迫地对付了敌人。惟独第三次战役，因为不料敌人经过第二次战役那么惨败之后，新的进攻来得那么快（一九三一年五月三十一日我们结束第二次反“围剿”的作战，七月一日蒋介石就开始了他们的第三次“围剿”），红军仓卒地绕道集中，就弄得十分疲劳。如何选择这个时机，全靠收集必要的材料，从敌我双方大势上去判断，和前面说过的选择准备阶段的开始时机所用的方法一样。   
　　战略退却，在干部和人民还没有经验时，在军事领导的权威还没有达到把战略退却的决定权集中到最少数人乃至一个人的手里而为干部所信服的地步时，说服干部和人民的问题是一个十分困难的问题。由于干部没有经验，对于战略退却不相信，在第一次和第四次反“围剿”的初期，第五次反“围剿”的整期，在这个问题上都遭遇了很大的困难。第一次反“围剿”时，由于立三路线的影响，干部的意见，在没有被说服以前，不是退却而是进攻。第四次反“围剿”时，由于军事冒险主义的影响，干部的意见是反对准备。第五次反“围剿”时，干部的意见开头是继续军事冒险主义反对诱敌深入的观点，后来是变成了军事保守主义。张国焘路线不相信在藏人和回人（46）地区不能建立我们的根据地，直待碰壁以后方才相信，也是实例。经验对于干部是必需的，失败确是成功之母。但是虚心接受别人的经验也属必需，如果样样要待自己经验，否则固执己见拒不接受，这就是十足的“狭隘经验论”。我们的战争吃这种亏是不少的。   
　　人民由于没有经验而不相信战略退却的必要，莫过于江西第一次反对“围剿”的时候。当时吉安、兴国、永丰等县的地方党组织和人民群众无不反对红军的退却。但是在有了这一次经验之后，在后来的几次反对“围剿”时，就完全没有这个问题了。大家相信，根据地的损失，人民的吃苦，是暂时的，大家都有了红军能够打破“围剿”的信心。然而人民的信任与否，密切地联系于干部的信任与否，因此主要的和首先的任务，是说服干部。   
　　战略退却的全部的作用，在于转入反攻，战略退却仅是战略防御的第一阶段。全战略的决定关键，在于随之而来的反攻阶段之能不能取胜。   
### 第四节　战略反攻  

  
　　战胜绝对优势敌人的进攻，依靠于在战略退却阶段中所造成的、有利于我不利于敌的、比较敌人开始进攻时起了变化的形势，而这种形势是由各种条件造成的。这在前面已经说过了。   
　　然而有利于我不利于敌的条件和形势的存在，还没有使敌人失败。这种条件和形势，具备着决定胜败的可能性，但还不是胜败的现实性，还没有实现两军的胜负。实现这个胜负，依靠两军的决战。只有决战，才能解决两军之间谁胜谁败的问题。这就是战略反攻阶段的全任务。反攻是一个长过程，是防御战的最精彩最活跃的阶段，也就是防御战的最后阶段。所谓积极防御，主要地就是指的这种带决战性的战略的反攻。   
　　条件和形势，不仅仅在战略退却阶段中造成，在反攻阶段中继续地造成着。这时的条件和形势，不完全和前一阶段中的条件和形势属于同一形式和同一性质。   
　　可以是属于同一形式和同一性质的，例如，此时敌军的更加疲劳和减员，不过是前一阶段中疲劳和减员的继续。   
　　但又必然地有完全新的条件和形势出现。例如，敌军打了一个或几个败仗，这时的有利于我不利于敌的条件，就不仅敌军疲劳等等，而是增加了敌军打败仗这个新的条件了。形势也起了新的变化。敌军调动忙乱，举措失当，两军优劣之势，也就不同于前了。   
　　假使一个到几个败仗不是属于敌军，而是属于我军，那末，条件和形势的有利与否，也变到相反的方面。就是说，敌之不利减少，我之不利开始发生，以至扩大起来。这又是完全新的不同于前的东西。   
　　无论何方失败，都直接地、迅速地引起失败者方面的一种新的努力，就是企图挽救危局的努力，使自己脱出这种新出现的不利于我有利于敌的条件和形势，而重新创造出有利于我不利于敌的条件和形势去压迫对方。   
　　胜利者方面的努力和这相反，力图发展自己的胜利，给敌人更大的损害，务求增加或发展有利于我的条件和形势，而务求不让对方完成其脱出不利和挽回危局的企图。   
　　所以，不论在何方说来，决战阶段的斗争，是全战争或全战役中最激烈、最复杂、最变化多端的，也是最困难、最艰苦的，在指挥上说来，是最不容易的时节。   
　　反攻阶段中，问题是很多的，主要的如反攻开始问题、集中兵力问题、运动战问题、速决战问题、歼灭战问题等。   
　　这些问题的原则，不论对于反攻说来，或对于进攻说来，在其基本性质上，是没有区别的。在这个意义上，可以说反攻就是进攻。   
　　然而反攻不完全是进攻。反攻原则，是在敌人进攻时应用的。进攻原则，是在敌人防御时应用的。在这个意义上，又都有若干的区别了。   
　　因为这个理由，虽然这里把作战的许多问题统统说在战略防御的反攻部门中，而在战略进攻部门中只说些另外的问题，以避重复，但我们应用时，却不可忽略其相同点，也不可忽略其差异点。   
### 第五节　反攻开始问题  

  
　　反攻开始问题，即所谓“初战”或“序战”问题。   
　　许多资产阶级军事家都主张慎重初战，不论在战略防御或战略进攻皆然，而以防御为尤甚。我们过去，也曾经严重地提出了这个问题。江西反对敌人第一次至第五次“围剿”的作战给了我们以丰富的经验，研究一下这些经验不是没有益处的。   
　　第一次“围剿”时，敌人以约十万人之众，由北向南，从吉安、建宁之线，分八个纵队向红军根据地进攻。当时的红军约四万人，集中于江西省宁都县的黄陂、小布地区。   
　　当时的情况是：（一）“进剿”军不过十万人，且均非蒋之嫡系，总的形势不十分严重。（二）敌军罗霖师防卫吉安，隔在赣江之西。（三）敌军公秉藩、张辉瓒、谭道源三师进占吉安东南、宁都西北的富田、东固、龙冈、源头一带。张师主力在龙冈，谭师主力在源头。富田、东固两地因人民受AB团欺骗一时不信任红军，并和红军对立，不宜选作战场。（四）敌军刘和鼎师远在福建白区的建宁，不一定越入江西。（五）敌军毛炳文、许克祥两师进至广昌宁都之间的头陂、洛口、东韶一带。头陂是白区，洛口是游击区，东韶有AB团，易走漏消息。且打了毛炳文许克祥再向西打，恐西面张辉瓒、谭道源、公秉藩三师集中，不易决胜，不能最后解决问题。（六）张、谭两师是“围剿”主力军，“围剿”军总司令江西主席鲁涤平的嫡系部队，张又是前线总指挥。消灭此两师，“围剿”就基本上打破了。两师各约一万四千人，张师又分置两处，我一次打一个师是绝对优势。（七）张、谭两师主力所在的龙冈、源头一带接近我之集中地，且人民条件好，能荫蔽接近。（八）龙冈有优良阵地。源头不好打。如敌攻小布就我，则阵地亦好。（九）我在龙冈方向能集中最大兵力。龙冈西南数十里之兴国，尚有一个千余人的独立师，亦可迂回于敌后。（一〇）我军实行中间突破，将敌人的阵线打开一缺口后，敌之东西诸纵队便被分离为远距之两群。基于以上理由，我们的第一仗就决定打而且打着了张辉瓒的主力两个旅和一个师部，连师长在内九千人全部俘获，不漏一人一马。一战胜利，吓得谭师向东韶跑，许师向头陂跑。我军又追击谭师消灭它一半。五天内打两仗（一九三〇年十二月三十日至一九三一年一月三日），于是富田、东固、头陂诸敌畏打纷纷撤退，第一次“围剿”就结束了。   
　　第二次“围剿”时的情况是：（一）“进剿”军二十万人，何应钦为总司令，驻南昌。（二）和第一次“围剿”时一样，全部是蒋之非嫡系部队。以蔡廷锴的第十九路军、孙连仲的第二十六路军、朱绍良的第六路军为最强或较强，其余均较弱。（三）AB团肃清，根据地人民全部拥护红军。（四）王金钰的第五路军从北方新到，表示恐惧，其左翼郭华宗、郝梦龄两师，大体相同。（五）我军从富田打起，向东横扫，可在闽赣交界之建宁、黎川、泰宁地区扩大根据地，征集资材，便于打破下一次“围剿”。若由东向西打去，则限于赣江，战局结束后无发展余地。若打完再东转，又劳师费时。（六）我军人数较上次战役时虽略减（三万余），然有四个月的养精蓄锐。基于以上理由，乃决找富田地区的王金钰、公秉藩（共十一个团）打第一仗。胜利后，接着打郭、打孙、打朱、打刘（47）。十五天中（一九三一年五月十六日至三十一日），走七百里，打五个仗，缴枪二万余，痛快淋漓地打破了“围剿”。当打王金钰时，处于蔡廷锴、郭华宗两敌之间，距郭十余里，距蔡四十余里，有人谓我们“钻牛角”，但终究钻通了。主要因为根据地条件，再加敌军各部之不统一。郭师败后，郝师星夜逃回永丰，得免于难。   
　　第三次“围剿”时的情况是：（一）蒋介石亲身出马任总司令，下分左右中三路总司令。中路何应钦，与蒋同驻南昌；右路陈铭枢，驻吉安；左路朱绍良，驻南丰（48）。（二）“进剿”军三十万人。主力军是蒋嫡系之陈诚、罗卓英、赵观涛、卫立煌、蒋鼎文等五个师，每师九团，共约十万人。次是蒋光鼐、蔡廷锴、韩德勤三师（49），四万人。次是孙连仲军，二万人。余均非蒋嫡系，较弱。（三）“进剿”战略是“长驱直入”，大不同于第二次“围剿”之“步步为营”，企图压迫红军于赣江而消灭之。（四）第二次“围剿”结束至第三次“围剿”开始，为时仅一个月。红军苦战后未休息，也未补充（三万人左右），又绕道千里回到赣南根据地西部之兴国集中，时敌已分路直迫面前。在上述情况下，我们决定的第一个方针，是由兴国经万安突破富田一点，然后由西而东，向敌之后方联络线上横扫过去，让敌主力深入赣南根据地置于无用之地，定此为作战之第一阶段。及敌回头北向，必甚疲劳，乘隙打其可打者，为第二阶段。此方针之中心是避敌主力，打其虚弱。但我军向富田开进之际，被敌发觉，陈诚、罗卓英两师赶至。我不得不改变计划，回到兴国西部之高兴圩，此时仅剩此一个圩场及其附近地区几十个方里容许我军集中。集中一天后，乃决计向东面兴国县东部之莲塘、永丰县南部之良村、宁都县北部之黄陂方向突进。第一天乘夜通过了蒋鼎文师和蒋、蔡、韩军间之四十华里空隙地带，转到莲塘。第二天和上官云相军（上官指挥他自己的一个师及郝梦龄师）前哨接触。第三天打上官师为第一仗，第四天打郝梦龄师为第二仗，尔后以三天行程到黄陂打毛炳文师为第三仗。三战皆胜，缴枪逾万（50）。此时所有向西向南之敌军主力，皆转旗向东，集中视线于黄陂，猛力并进，找我作战，取密集的大包围姿势接近了我军。我军乃于蒋、蔡、韩军和陈、罗军之间一个二十华里间隙的大山中偷越过去，由东面回到西面之兴国境内集中。及至敌发觉再向西进时，我已休息了半个月，敌则饥疲沮丧，无能为力，下决心退却了。我又乘其退却打了蒋光鼐、蔡廷锴、蒋鼎文、韩德勤，消灭蒋鼎文一个旅、韩德勤一个师。对蒋光鼐、蔡廷锴两师，则打成对峙，让其逃去了。   
　　第四次“围剿”时的情况是：敌分三路向广昌进，主力在东路，西路两师暴露于我面前，且迫近我之集中地。因此我得以先打其西路于宜黄南部地区，一举消灭李明、陈时骥两个师。敌从左路分出两个师配合中路再进，我又得消灭其一个师于宜黄南部地区。两役缴枪万余，这个“围剿”就基本地打破了。   
　　第五次“围剿”，敌以堡垒主义的新战略前进，首先占领了黎川。我却企图恢复黎川，御敌于根据地之外，去打黎川以北敌之巩固阵地兼是白区之硝石。一战不胜，又打其东南之资溪桥，也是敌之巩固阵地和白区，又不胜。尔后辗转寻战于敌之主力和堡垒之间，完全陷入被动地位。终第五次反“围剿”战争一年之久，绝无自主活跃之概。最后不得不退出江西根据地。   
　　上述第一次至第五次反“围剿”时期我军作战的经验，证明处在防御地位的红军，欲打破强大的“进剿”军，反攻的第一个战斗，关系非常之大。第一个战斗的胜败给予极大的影响于全局，乃至一直影响到最后的一个战斗。因此得出下述的结论：   
　　第一，必须打胜。必须敌情、地形、人民等条件，都利于我，不利于敌，确有把握而后动手。否则宁可退让，持重待机。机会总是有的，不可率尔应战。第一次反“围剿”时先想打谭道源，仅因敌不脱离源头那个居高临下的阵地，我军两度开进，却两度忍耐撤回，过了几天找到了好打的张辉瓒。第二次反“围剿”时，我军开进到东固，仅因等待王金钰脱离其富田巩固阵地，宁可冒犯走漏消息的危险，拒绝一切性急快打的建议，迫敌而居，等了二十五天之久，终于达到了要求。第三次反“围剿”虽是那样急风暴雨的局面，千里回师，又被敌人发觉了我们迂回其侧后的计划，但我们仍忍耐折回，改用中间突破，终于在莲塘打着第一个好仗。第四次反“围剿”时攻南丰不克，毅然采取了退却步骤，终于转到敌之右翼，集中东韶地区，开始了宜黄南部的大胜仗。只有第五次反“围剿”时全不知初战关系之大，震惊于黎川一城之失，从挽救的企图出发，北上就敌，于洵口不预期遭遇战胜利（消灭敌一个师）之后，却不把此战看作第一战，不看此战所必然引起的变化，而贸然进攻不可必胜的硝石。开脚一步就丧失了主动权，真是最蠢最坏的打法。   
　　第二，初战的计划必须是全战役计划的有机的序幕。没有好的全战役计划，绝不能有真正好的第一仗。这就是说，即使初战打了一个胜仗，若这个仗不但不于全战役有利，反而有害时，则这个仗虽胜也只算败了（例如第五次“围剿”时的洵口战斗）。因此在打第一仗之先，必须想到第二、第三、第四以至最后一仗大体上如何打法，我挨次的一仗胜了，敌军全局将起如何变化，假若败了，又将起如何变化。虽结果不见得乃至决不会尽如所期，然而必须依据双方全局，仔细地切实地想明白。没有全局在胸，是不会真的投下一着好棋子的。   
　　第三，还要想到下一战略阶段的文章。若只顾反攻，不顾反攻胜利后，或万一反攻失败后，下文如何做法，依然未尽得战略指导者的责任。战略指导者当其处在一个战略阶段时，应该计算到往后多数阶段，至少也应计算到下一个阶段。尽管往后变化难测，愈远看愈渺茫，然而大体的计算是可能的，估计前途的远景是必要的。那种走一步看一步的指导方式，对于政治是不利的，对于战争也是不利的。走一步应该看那一步的具体变化，据此以修改或发展自己战略战役计划，不这样做，就会弄出冒险直冲的错误。然而贯通全战略阶段乃至几个战略阶段的、大体上想通了的、一个长时期的方针，是决不可少的。不这样做，就会弄出迟疑坐困的错误，实际上适合了敌人的战略要求，陷自己于被动地位。须知敌人的统帅部，是具有某种战略眼光的。我们只有使自己操练得高人一等，才有战略胜利的可能。在敌人第五次“围剿”时期“左”倾机会主义路线和张国焘路线的战略指导之所以错误，主要地就在于没有作到这一点。总之，退却阶段时必须计算到反攻阶段，反攻阶段时必须计算到进攻阶段，进攻阶段时又须计算到退却阶段。没有这种计算，束缚于眼前的利害，就是失败之道。   
　　必须打胜；必须照顾全战役计划；必须照顾下一战略阶段：这是反攻开始，即打第一仗时，不可忘记的三个原则。   
### 第六节　集中兵力问题  

  
　　集中兵力看来容易，实行颇难。人人皆知以多胜少是最好的办法，然而很多人不能做，相反地每每分散兵力，原因就在于指导者缺乏战略头脑，为复杂的环境所迷惑，因而被环境所支配，失掉自主能力，采取了应付主义。   
　　无论处于怎样复杂、严重、惨苦的环境，军事指导者首先需要的是独立自主地组织和使用自己的力量。被敌逼迫到被动地位的事是常有的，重要的是要迅速地恢复主动地位。如果不能恢复到这种地位，下文就是失败。   
　　主动地位不是空想的，而是具体的，物质的。这里最重要的，是保存并集结最大而有活力的军队。   
　　防御战本来容易陷入被动地位，防御战大不如进攻战之能够充分地发挥主动权。然而防御战是能够在被动的形式中具有主动的内容的，是能够由形式上的被动阶段转入形式上内容上的主动阶段的。完全有计划的战略退却，在形式上是被逼出此的，在内容上是保存军力，待机破敌，是诱敌深入，准备反攻。只有不肯退却，仓卒应战（例如硝石战斗），表面上似乎在力争主动，实际上是被动的。战略反攻，则不但内容是主动的，形式上也放弃了退却时的被动姿态。对于敌军说来，反攻是我军强迫它放弃主动权，同时即给以被动地位的努力。   
　　要完全达到这种目的，集中兵力、运动战、速决战、歼灭战，都是必要的条件。而集中兵力，是首先的和主要的。   
　　集中兵力之所以必要，是为了改变敌我的形势。第一，是为了改变进退的形势。过去是敌进我退，现在是企图达到我进敌退之目的。集中兵力一战而胜，这个目的在本战斗就达到了，也给予影响于全战役。   
　　第二，是为了改变攻守的形势。退却到退却终点，在防御战中基本上属于消极阶段，即“守”的阶段。反攻则属于积极阶段，即“攻”的阶段。虽然在整个战略防御中并没有脱离防御性质，然而反攻和退却相较，不但形式上，而且内容上，是起了变化的东西。反攻是战略防御和战略进攻之间的过渡的东西，带着战略进攻前夜的性质，集中兵力就为达此目的。   
　　第三，是为了改变内外线的形势。处于战略上内线作战的军队，特别是处于被“围剿”环境的红军，蒙受着许多的不利。但我们可以而且完全应该在战役或战斗上，把它改变过来。将敌军对我军的一个大“围剿”，改为我军对敌军的许多各别的小围剿。将敌军对我军的战略上的分进合击，改为我军对敌军的战役或战斗上的分进合击。将敌军对我军的战略上的优势，改为我军对敌军的战役或战斗上的优势。将战略上处于强者地位的敌军，使之在战役或战斗上处于弱者的地位。同时，将自己战略上的弱者地位，使之改变为战役上或战斗上的强者的地位。这即是所谓内线作战中的外线作战，“围剿”中的围剿，封锁中的封锁，防御中的进攻，劣势中的优势，弱者中的强者，不利中的有利，被动中的主动。从战略防御中争取胜利，基本上靠了集中兵力的一着。   
　　在中国红军的战史中，这个问题常常成为重要的争论问题。一九三〇年十月四日吉安之役，不待兵力完全集中就实行开进和攻击，幸而敌人（邓英师）自己逃走了，我们的攻击本身并没有奏效。   
　　从一九三二年开始，有所谓“全线出击”的口号，要求从根据地的东西南北四面出击。这不但在战略防御时不对，就是在战略进攻时也是不对的。在整个敌我对比的形势没有根本改变的时候，无论战略或战术，都有防御和进攻、钳制和突击的两方面，事实上绝少所谓全线出击。全线出击的口号，是伴随军事冒险主义而来的军事平均主义。   
　　军事平均主义者到一九三三年，有所谓“两个拳头打人”的说法，把红军主力分割为二，企图在两个战略方向同时求胜。那时的结果是一个拳头置于无用，一个拳头打得很疲劳，而且没有当时可能取得的最大胜利。照我的意见，在有强大敌军存在的条件下，无论自己有多少军队，在一个时间内，主要的使用方向只应有一个，不应有两个。我不反对作战方向有两个或两个以上，但主要的方向，在同一个时间内，只应有一个。中国红军以弱小者的姿态出现于内战的战场，其迭挫强敌震惊世界的战绩，依赖于兵力集中使用者甚大。无论哪一个大胜仗，都可以证明这一点。“以一当十，以十当百”，是战略的说法，是对整个战争整个敌我对比而言的；在这个意义上，我们确实是如此。不是对战役和战术而言的；在这个意义上，我们决不应如此。无论在反攻或进攻，我们总是集结大力打敌一部。一九三一年一月的江西宁都县东韶地区打谭道源的作战，一九三一年九月的江西兴国县高兴圩地区打十九路军的作战，一九三二年七月广东南雄县水口圩地区打陈济棠的作战，一九三三年十二月江西黎川县团村地区打陈诚的作战，都吃了兵力不集中的亏。如像水口圩和团村这一类的仗，本来一般算作胜仗，而且还算作大胜仗的（前者击溃陈济棠二十个团，后者击溃陈诚十二个团〔51〕），然而我们历来就不欢迎这种胜仗，在某种意义上简直还可以说它是败仗。因为没有缴获或缴获不超过消耗，在我们看来是很少意义的。我们的战略是“以一当十”，我们的战术是“以十当一”，这是我们制胜敌人的根本法则之一。   
　　军事平均主义，到一九三四年第五次反“围剿”时，发展到了极点。“六路分兵”，“全线抵御”，以为可以制敌，结果为敌所制，原因在于惧怕丧失土地。集中主力于一个方向，其他方向剩下了钳制力量，自然不免使土地受到损失。然而这是暂时的局部的损失，其代价是突击方向取得了胜利。突击方向胜利了，钳制方向的损失就可以恢复了。敌人的第一、二、三、四次“围剿”都使我们遭受了土地的损失，特别是在敌人第三次“围剿”时江西红军根据地几乎全部丧失了，然而结果我们的土地不但都恢复了，而且还扩大了。   
　　由于看不见根据地人民的力量，常常发生惧怕红军远离根据地的错误心理。这种心理在一九三二年江西红军远出打福建的漳州时，一九三三年第四次反“围剿”战役胜利后红军转向福建进攻时，都曾发生过。前者惧怕整个根据地被占，后者惧怕根据地的一部被占，而反对集中兵力，主张分兵把守，结果都证明不对。在敌人看来，一方面根据地使他们畏进，一方面打到白区去的红军是他们的主要的危险物。敌军的注意力总是向着主力红军所在地，抛开主力红军不顾而专向根据地，是很少这种事情的。在红军实行防御时，敌人的注意力也还是集中于红军。缩小根据地的计划是敌人整个计划的一部分；但是如果红军集中主力消灭其一路，敌军统帅部就不得不把他们的注意力和他们的军力更大地向着红军。所以，敌人缩小根据地的计划，也是能够破坏的。   
　　“堡垒主义的五次‘围剿’时期我们不能集中作战，只能分兵防御从事短促突击”，这种说法也是不对的。敌人三里五里一进、十里八里一推的堡垒主义作战法，完全是红军自己的节节抗御促成的。如果我军在内线放弃节节抗御的战法，再在必要和可能时转向敌人的内线打去，局面必然是另外一种。集中兵力的法则，正是战胜堡垒主义的工具。   
　　我们主张的集中兵力，并不包括放弃人民的游击战争在内。立三路线主张废弃小的游击战争，“一枝枪也集中到红军中去”，早已证明是不对的了。人民的游击战争，从整个革命战争的观点看来，和主力红军是互为左右手，只有主力红军而无人民的游击战争，就像一个独臂将军。根据地的人民条件，具体地说来，特别是对于作战说来，就是有武装起来了的人民。敌人视为畏途，主要地也在这一点。   
　　置红军的支队于次要的作战方向也是必要的，不是一切都要集中。我们主张的集中兵力，是建立在保证对于战场作战的绝对或相对优势的原则上。对于强敌，或关系紧要的战场作战，应以绝对优势的兵力临之，例如一九三〇年十二月三十日第一次反“围剿”的第一仗，集中四万人打张辉瓒的九千人。对于弱敌或不关紧要的战场作战，临之以相对优势的兵力也就够了，例如一九三一年五月三十一日第二次反“围剿”的最后一战，向建宁打七千人的刘和鼎师，红军只用了一万多人。   
　　也不是说每次都要优势兵力。在某种情况下，也可以用相对劣势或绝对劣势兵力出现于战场。相对劣势，例如某一区域仅仅有一支不大的红军（不是有兵而不集中），为着打破某一优势敌人的进攻，在人民、地形或天候等条件能给我们以大的援助时，以游击队或小支队钳制其正面及一翼，红军集中全力突然袭击其另一翼的一部分，当然也是必要的，并且是可以胜利的。当我袭击其一翼的一部分时，兵力的对比仍适用以优势对劣势、以多胜少的原则。绝对劣势，例如游击队袭击白军大队伍，仅仅是袭击其一小部分，同样适用上述的原则。   
　　集中大军于一个战场作战，受限制于地形、道路、给养、驻处等的说法，也应分别情形去看。这些限制，对于红军和白军是有程度上的区别的，因为红军较之白军能够忍受更大的困难。   
　　我们是以少胜多的——我们向整个中国统治者这样说。我们又是以多胜少的——我们向战场上作战的各个局部的敌人这样说。这件事情已经不是什么秘密，敌人一般地都摸熟我们的脾气了。然而敌人不能取消我们的胜利，也不能避免他们的损失，因为何时何地我们这样做，他们不晓得。这一点我们是保守秘密的。红军的作战一般是奇袭。   
### 第七节　运动战  

  
　　运动战，还是阵地战？我们的答复是：运动战。在没有广大兵力，没有弹药补充，每一个根据地打来打去仅只有一支红军的条件下，阵地战对于我们是基本上无用的。阵地战，对于我们，不但防御时基本地不能用它，就是进攻时也同样不能用。   
　　由于敌人强大和红军技术贫弱所发生的红军作战的显著特点之一，就是没有固定的作战线。   
　　红军的作战线，服从于红军的作战方向。作战方向不固定，影响到作战线不固定。大方向虽在一个时期中是不变更的，然而大方向内的小方向则是随时变更的，一个方向受了限制，就得转到另一个方向去。一个时期之后大方向也受了限制，就连这种大方向也得变更了。   
　　革命的内战时期，作战线不能固定，就在苏联也有过这种情形。苏联军队和我们的军队不同的地方，在于其不固定的程度不如我们之甚。一切战争也不能有绝对固定的作战线，胜负进退的变化不许可如此。但是相对固定的作战线往往见之于一般的战争。惟独敌我强弱悬殊像处在目前阶段的中国红军这样的军队，则是例外。   
　　作战线的不固定，影响到根据地领土的不固定。时大时小时缩时伸是经常的，此起彼落也往往发生。这种领土的流动性，完全是来源于战争的流动性。   
　　战争和领土的流动性，影响到根据地各种建设工作也发生流动性。若干年月的建设计划是不能设想的。计划改变的频繁，是我们家常便饭的事情。   
　　承认这种特点，对于我们是有利益的。从这个特点出发，规定我们的日程，不要幻想有进无退的战争，不要震惊于领土和军事后方的暂时的流动，不要企图建立长时期的具体计划。把我们的思想、工作适应于情况，准备坐下，又准备走路，不要把干粮袋丢掉了。只有在现在的流动生活中努力，才能争取将来的比较地不流动，才能争取最后的稳定。   
　　统治着第五次反“围剿”时期的所谓“正规战争”的战略方针，否认这种流动性，反对所谓“游击主义”。反对流动的同志们要装作一个大国家的统治者来办事，结果是得到了一个异乎寻常的大流动——二万五千华里的长征。   
　　我们的工农民主共和国是一个国家，但是今天还是一个不完全的国家。今天我们还处在内战的战略防御时期，我们的政权距离一个完全的国家形态还很远，我们军队的数量和技术较之敌人还差得远，我们的领土还很小，我们的敌人时时刻刻想要消灭我们才快活。从这个上面规定我们的方针，不是一般地反对游击主义，而是老老实实地承认红军的游击性。在这里怕羞是没有用的。相反，游击性正是我们的特点，正是我们的长处，正是我们战胜敌人的工具。我们应该准备抛弃游击性，但是今天还不能抛弃。游击性在将来一定是可羞的和必须抛弃的东西，但在今天却是宝贵的和必须坚持的东西。   
　　“打得赢就打，打不赢就走”，这就是今天我们的运动战的通俗的解释。天下也没有只承认打不承认走的军事家，不过不如我们走得这么厉害罢了。对于我们，走路的时间通常多于作战的时间，平均每月打得一个大仗就算是好的。一切的“走”都是为着“打”，我们的一切战略战役方针都是建立在“打”的一个基本点上。然而在我们面前有几种不好打的情形：第一是当面的敌人多了不好打；第二是当面敌人虽不多，但它和邻近敌人十分密接，也有时不好打；第三，一般地说来，凡不孤立而占有十分巩固阵地之敌都不好打；第四是打而不能解决战斗时，不好再继续打。以上这些时候，我们都是准备走的。这样的走是许可的，是必须的。因为我们承认必须的走，是在首先承认必须的打的条件之下。红军的运动战的基本特点，就在这里。   
　　基本的是运动战，并不是拒绝必要的和可能的阵地战。战略防御时，我们钳制方面某些支点的固守，战略进攻时遇着孤立无援之敌，都是应该承认用阵地战去对付的。采取这样的阵地战制胜敌人的经验，我们过去已经不少；很多的城市、堡垒、寨子，被我们打开，某种程度的敌人野战阵地被我们突破。以后还要增加这一方面的努力，补足我们这一方面的弱点。我们完全应该提倡那种在情况需要而且许可下的阵地攻击和阵地防御。我们所反对的，仅仅是在今天采取一般的阵地战，或者把阵地战和运动战平等看待，这些才是不能许可的。   
　　红军的游击性，没有固定作战线，根据地的流动性，根据地建设工作的流动性，十年战争中一点也没有变化吗？有变化的。从井冈山到江西第一次反“围剿”前为第一个阶段，这个阶段中游击性和流动性是很大的，红军还在幼年时代，根据地还是游击区。从第一次反“围剿”到第三次反“围剿”为第二个阶段，这个阶段中游击性和流动性就缩小了许多，方面军已经建立，包含几百万人口的根据地已经存在。从第三次反“围剿”后至第五次反“围剿”为第三个阶段，游击性流动性更缩小了。中央政府与革命军事委员会已经建立。长征是第四个阶段。由于错误地否认小游击和小流动，就来了一个大游击和大流动。目前是第五个阶段。由于没有战胜第五次“围剿”和大流动，红军和根据地都大大地缩小了，但又已经在西北立住了脚根，巩固了并发展了陕甘宁边区根据地。红军主力三个方面军已经统一指挥，此事为前此所未有。   
　　依战略的性质说，也可以说井冈山时期至第四次反“围剿”时期为一阶段，第五次反“围剿”时期为又一阶段，长征至今为第三阶段。第五次反“围剿”时人们错误地否定了以前本来是正确的方针，我们今天又正确地否定了第五次反“围剿”时人们的错误方针，复活了从前的正确方针。然而不是否定第五次反“围剿”时的一切，也不是复活从前的一切。复活的是从前优良的东西，否定的是第五次反“围剿”时的错误的东西。   
　　游击主义有两方面。一方面是非正规性，就是不集中、不统一、纪律不严、工作方法简单化等。这些东西是红军幼年时代本身带来的，有些在当时还正是需要的。然而到了红军的高级阶段，必须逐渐地自觉地去掉它们，使红军更集中些，更统一些，更有纪律些，工作更周密些，就是说使之更带正规性。在作战指挥上，也应逐渐地自觉地减少那些在高级阶段所不必要的游击性。在这一方面拒绝前进，固执地停顿于旧阶段，是不许可的，是有害的，是不利于大规模作战的。   
　　另一方面是运动战的方针，是现在还需要的战略和战役作战的游击性，是无法阻止的根据地的流动性，是根据地建设计划的灵活变更性，是在红军建设上的不要不适时宜的正规化。在这一方面拒绝历史事实，反对保留有用的东西，贸然地脱离现阶段，盲目地跑向可望不可即的、在当前没有现实意义的所谓“新阶段”，同样是不许可的，是有害的，是不利于当前作战的。   
　　我们现在是处在红军技术和组织的下一新阶段的前夜。我们应该准备转变到新阶段去。不作这种准备是不对的，是不利于将来的战争的。在将来，红军的技术和组织条件改变了，红军建设进到了新阶段，红军的作战方向和作战线的比较固定就出现了；阵地战增加了；战争的流动性、领土和建设的流动性，大大减少了，到最后，也就会消灭了；现在限制着我们的东西，如像优势的敌人及其据守的巩固阵地，就不能限制我们了。   
　　我们现在一方面反对“左”倾机会主义统治时期的错误的办法，另一方面也反对复活红军幼年时代的许多在现时不需要的非正规性。但是我们要坚决地恢复红军一路来用以打胜仗的许多可宝贵的建军原则和战略战术原则。我们要把所有一切过去的优良的东西都总结起来，成为有系统的更发展的更丰富的军事路线，以便争取在今天战胜敌人，并且准备在将来转变到新阶段去。   
　　运动战的实行方面，问题是很多的，例如侦察、判断、决心、战斗部署、指挥、荫蔽、集中、开进、展开、攻击、追击、袭击、阵地攻击、阵地防御、遭遇战、退却、夜战、特种战斗、避强打弱、围城打援、佯攻、防空、处在几个敌人之间、超越敌人作战、连续作战、无后方作战、养精蓄锐之必要等等。这些问题在红军战史中都表现了许多的特点，战役学中应当有条理地叙述到，应当给以总结，我在这里就不说了。   
### 第八节　速决战  

  
　　战略的持久战，战役和战斗的速决战，这是一件事的两方面，这是国内战争的两个同时并重的原则，也可以适用于反对帝国主义的战争。   
　　因为反动势力的雄厚，革命势力是逐渐地生长的，这就规定了战争的持久性。在这上面性急是要吃亏的，在这上面提倡“速决”是不正确的。干了十年的革命战争，对于别的国家也许是值得惊奇的，对于我们却好似八股文章还只作了破题、承题和起讲（52），许多热闹文章都还在后面。往后的发展，在一切内外条件的影响下，无疑地将比过去有大大地增高速度的可能。因为国际和国内的环境已经起了变化，而且会有更大的变化要到来，可以说我们已经脱离了过去的那种慢慢发展的孤军作战的景况。然而不应该打算明天就会成功。“灭此朝食”（53）的气概是好的，“灭此朝食”的具体计划是不好的。因为中国的反动势力，是许多帝国主义支持的，国内革命势力没有聚积到足以突破内外敌人的主要阵地以前，国际革命势力没有打破和钳制大部分国际反动势力以前，我们的革命战争依然是持久的。从这一点出发，规定我们长期作战的战略方针，是战略指导的重要方针之一。   
　　战役和战斗的原则与此相反，不是持久而是速决。在战役和战斗上面争取速决，古今中外都是相同的。在战争问题上，古今中外也都无不要求速决，旷日持久总是认为不利。惟独中国的战争不能不以最大的忍耐性对待之，不能不以持久战对待之。有人在立三路线时期讥笑我们的做法为“打拳战术”（说的是打过来打过去才能夺取大城市），讥笑我们要待头发白了才能看见革命的胜利。这种表现急性病的情绪，早已证明是不对了。但是他们的批评意见如果不是放在战略问题上而是放在战役和战斗的问题上，则是非常之对的。原因在于：第一，红军的武器尤其是弹药没有来源；第二，白军有很多支部队，红军只一支部队，打破一次“围剿”要准备迅速的连续的作战；第三，白军各个虽然分进，但多是比较地密集，打它们中间的一个如果不能迅速地解决战斗，其余各个就都来了。为了这些理由，不能不实行速决战。对于我们，几小时，一天或两天解决一个战斗是经常的。只有在“围城打援”的方针下，目的不在打围敌，而在打援敌，对围敌作战是准备着相当地持久的，但对援敌仍然是速决。战略防御时固守钳制方面的据点，战略进攻时打孤立无援之敌，消灭根据地中的白色据点，这些时候也常常给予战役或战斗以持久方针。然而这些持久战，只是帮助而并不妨碍主力红军的速决战。   
　　速决战不是心里想要如此做就做得成功的，还须加上许多具体的条件。主要的条件是准备充足，不失时机，集中优势兵力，包围迂回战术，良好阵地，打运动中之敌，或打驻止而阵地尚不巩固之敌。不解决这些条件，而求战役或战斗的速决，是不可能的。   
　　打破一次“围剿”属于一个大战役，依然适用速决原则，而不是持久原则。因为根据地的人力、财力、军力等项条件都不许可持久。   
　　但在一般的速决原则之下，反对不正当的急躁性是必要的。一个革命根据地的最高军事政治领导机关，估计到根据地的这些条件，估计到敌方情况，不为敌之其势汹汹所吓倒，不为尚能忍耐的困难所沮丧，不为某些挫折而灰心，给予必要的耐心和持久，是完全必要的。江西打破第一次“围剿”，从初战到结束只有一星期，打破第二次“围剿”只有半个月，打破第三次“围剿”就熬上了三个月，第四次是三星期，第五次就熬了整整的一年。但是第五次没有打破“围剿”而被迫突围时，还表现了不应有的仓卒从事。依情况还可以熬上两三个月，用以休整军队。假如这样，又假如突围后的领导稍为聪明一点，情况便将有很大的不同。   
　　虽然如此，仍然不破坏我们所说的力争缩短全战役时间的原则。除了战役战斗计划力争集中兵力和运动战等等条件、务期在内线（在根据地）消灭敌之有生力量、迅速解决“围剿”以外，当“围剿”已经证明无法在内线解决时，应该使用红军主力突破敌之围攻线，转入我之外线即敌之内线去解决这个问题。堡垒主义发达的今日，这种手段将要成为经常的作战手段。第五次反“围剿”进行两个月之后，当福建事变出现之时，红军主力无疑地应该突进到以浙江为中心的苏浙皖赣地区去，纵横驰骋于杭州、苏州、南京、芜湖、南昌、福州之间，将战略防御转变为战略进攻，威胁敌之根本重地，向广大无堡垒地带寻求作战。用这种方法，就能迫使进攻江西南部福建西部地区之敌回援其根本重地，粉碎其向江西根据地的进攻，并援助福建人民政府，——这种方法是必能确定地援助它的。此计不用，第五次“围剿”就不能打破，福建人民政府也只好倒台。到打了一年之久的时候，虽已不利于出浙江，但还可以向另一方向改取战略进攻，即以主力向湖南前进，不是经湖南向贵州，而是向湖南中部前进，调动江西敌人至湖南而消灭之。此计又不用，打破第五次“围剿”的希望就最后断绝，剩下长征一条路了。   
### 第九节　歼灭战  

  
　　“拚消耗”的主张，对于中国红军来说是不适时宜的。“比宝”不是龙王向龙王比，而是乞丐向龙王比，未免滑稽。对于几乎一切都取给于敌方的红军，基本的方针是歼灭战。只有歼灭敌人的有生力量才能打破“围剿”和发展革命根据地。给敌以杀伤，是作为给敌以歼灭的手段而采取的，否则便没有意义。因给敌以杀伤而给我以消耗，又因给敌以歼灭而给我以补充，这样就不但抵偿了我军的消耗，而且增加了我军的力量。击溃战，对于雄厚之敌不是基本上决定胜负的东西。歼灭战，则对任何敌人都立即起了重大的影响。对于人，伤其十指不如断其一指；对于敌，击溃其十个师不如歼灭其一个师。   
　　对于第一、二、三、四次“围剿”，我们的方针都是歼灭战。每次歼灭的敌人对于全敌不过是一部分，然而“围剿”是打破了。第五次反“围剿”时，采取了相反的方针，实际上是帮助敌人达到了他们的目的。   
　　歼灭战和集中优势兵力、采取包围迂回战术，同一意义。没有后者，就没有前者。人民赞助、良好阵地、好打之敌、出其不意等条件，都是达到歼灭目的所不可缺少的。   
　　击溃有意义，乃至让敌逃去有意义，只是对于全战斗或全战役中我军主力对确定之敌举行歼灭性的作战而说的，否则便没有什么意义。这又是一种有所失对有所得而有意义的场合。   
　　我们建立军事工业，须使之不助长依赖性。我们的基本方针是依赖帝国主义和国内敌人的军事工业。伦敦和汉阳的兵工厂，我们是有权利的，并且经过敌人的运输队送来。这是真理，并不是笑话。  
  
------------------  
　　注　　释   
　　〔1〕 “实际”这一个概念，按照中国文字，有两种含义：一种是指真实的情况，一种是指人们的行动（也即一般人所说的实践）。毛泽东在他的著作中，应用这一个概念，时常是双关的。   
　　〔2〕 孙武子即孙武，中国春秋时代的著名军事学家，著《孙子》十三篇。本文引语见《孙子·谋攻》。   
　　〔3〕从一九二一年七月中国共产党成立到一九三六年毛泽东著此文时，正是十五年。   
　　〔4〕陈独秀（一八七九——一九四二），安徽怀宁人。五四新文化运动的主要领导人之一。五四运动后，接受和宣传马克思主义，是中国共产党的主要创建人之一。在党成立后的最初六年中是党的主要领导人。陈独秀右倾机会主义指一九二七年上半年以陈独秀为代表的右倾投降主义错误。当时他放弃对于农民群众、城市小资产阶级和中等资产阶级的领导权，尤其是放弃对于武装力量的领导权，主张一切联合，否认斗争，对国民党右派反共反人民的阴谋活动采取妥协投降的政策，以致当大地主大资产阶级的代表蒋介石、汪精卫先后背叛革命，向人民突然袭击的时候，中国共产党和广大革命人民不能组织有效的抵抗，使第一次国内革命战争遭到失败。同年八月七日，中共中央在汉口召开紧急会议，总结了大革命失败的经验教训，结束了陈独秀右倾投降主义在党中央的统治。其后，陈独秀对于革命前途悲观失望，接受托派观点，在党内成立小组织，进行反党活动，一九二九年十一月被开除出党。一九三二年十月被国民党政府逮捕，一九三七年八月出狱。一九四二年病故于四川江津。   
　　〔5〕李立三（一八九九——一九六七），湖南醴陵人。一九二一年加入中国共产党，是中国工人运动的主要领导人之一。李立三“左”倾机会主义指第二次国内革命战争期间以他为代表的“左”倾冒险主义错误。一九三〇年六月十一日，中共中央政治局在李立三领导下通过了《新的革命高潮与一省或几省的首先胜利》决议案，主张全国各地都要准备马上起义。不久，订出了组织全国中心城市武装起义和集中全国红军进攻中心城市的冒险计划，随后又将党、青年团、工会的各级领导机关，合并为准备武装起义的各级行动委员会，使一切经常工作陷于停顿。同年九月中共中央召开六届三中全会，纠正了李立三的“左”倾冒险主义错误。后来李立三接受了党对他所犯错误的批评，认识和改正了错误，在中共第七次、第八次全国代表大会上继续被选为中央委员。   
　　〔6〕一九三一年一月，在中国共产党的六届四中全会上，王明（陈绍禹）等人在共产国际及其代表米夫的支持下，取得了在党中央的领导地位。他们在政治上混淆民主革命和社会主义革命的界限，把反资产阶级和反帝反封建并列；否认九一八事变后国内阶级关系的明显变化，把中间势力当成“最危险的敌人”；继续推行“城市中心论”，主张红军夺取中心城市以实现一省数省首先胜利而形成全国的胜利。在军事上，先是推行冒险主义，后来又变为保守主义和逃跑主义。在组织上，实行宗派主义，对不同意他们错误主张的人，进行“残酷斗争，无情打击”。王明“左”倾冒险主义在党内统治达四年之久，给党和革命事业造成了重大的损失。一九三五年一月，中共中央政治局召开遵义会议，确立了以毛泽东为代表的新的中央的正确领导，从而结束了王明“左”倾冒险主义在党中央的统治。   
　　〔7〕遵义会议指一九三五年一月长征途中，中共中央政治局在贵州遵义举行的扩大会议。这次会议集中讨论和纠正了军事上和组织上的错误，结束了王明“左”倾冒险主义在党中央的统治，确立了以毛泽东为代表的新的中央的正确领导，在最危急的关头挽救了红军，挽救了党。   
　　〔8〕 参见本卷《论反对日本帝国主义的策略》注〔23〕和注〔24〕。   
　　〔9〕庐山军官训练团是蒋介石训练反共军事干部的组织，创办于一九三三年七月，地址在江西省的庐山。该团对围攻红军的蒋介石嫡系部队的军官进行军事的和政治的训练，以便普遍推行构筑碉堡以及其他进攻红军的办法。到一九三四年，训练的对象扩大到各非嫡系部队的军官，借以加强蒋介石对各地方军阀的控制。   
　　〔10〕这里所说的第五次“围剿”的新军事原则，主要是指国民党反动派的碉堡推进、步步为营的“堡垒政策”。参见本卷《关心群众生活，注意工作方法》注〔4〕。   
　　〔11〕参见列宁《共产主义》。在该文中列宁批评匈牙利共产党员库恩·贝拉说：“他忽略了马克思主义的精髓，马克思主义的活的灵魂：对具体情况作具体分析。”（《列宁全集》第39卷，人民出版社1986年版，第128页）   
　　〔12〕中国共产党湘赣边界第一次代表大会于一九二八年五月在江西省宁冈县茅坪召开。这次大会分析了当时的政治形势，讨论了发展党的组织、深入土地革命、巩固和扩大红军及革命根据地等项任务，初步回答了红军中有些人提出的“红旗到底打得多久”的疑问。大会还选出以毛泽东为书记的中共湘赣边界特别委员会。这次会议促进了井冈山革命根据地的发展。   
　　〔13〕 见本卷《星星之火，可以燎原》注〔11〕。   
　　〔14〕 参见本卷《关于纠正党内的错误思想》注〔4〕和注〔5〕。   
　　〔15〕 土匪主义指无纪律、无组织、无明确的政治目标的抢掠行为。   
　　〔16〕指中央红军（第一方面军）从江西瑞金等地出发转移到陕西北部的长征。参见本卷《论反对日本帝国主义的策略》注〔22〕。   
　　〔17〕参见本卷《星星之火，可以燎原》注〔7〕。   
　　〔18〕一九二九年七月，驻赣、闽、粤三省的国民党军队对红四军和闽西革命根据地发动第一次“围剿”。红四军前委决定：以第一纵队和第四纵队留闽西坚持游击战争，军部率领第二、第三两纵队出击闽中。九月，出击闽中的红四军主力在中途遇到很大的困难，遂回师闽西，先后歼灭了上杭、武平等地的敌军。同时，第一、第四纵队在中共闽西特委的领导下，和广大群众武装一起，开展游击战争，迫使赣敌退守长汀、连城，粤敌退守永定。第一次“围剿”至此被粉碎。一九三〇年一月初，赣、闽、粤三省的国民党军队又以十四个团的兵力分七路“围剿”闽西的红军。为粉碎敌人的“围剿”，红四军前委决定挺进江西，出击“围剿”军的主力江西敌军的后方。江西敌军仓皇回兵自救，福建敌军因内部冲突也从闽西撤走。这样，敌人的第二次“围剿”很快也被打破。   
　　〔19〕 “偏师”，即不是主力军，只是侧翼的一部分军队。   
　　〔20〕一九三〇年十二月至一九三一年五月，国民党军队曾对鄂豫皖革命根据地进行过两次“围剿”，都被红军打败。一九三一年九月，蒋介石又开始筹划对鄂豫皖革命根据地的第三次“围剿”。至同年十一月，集结在根据地周围的国民党军队已达十五个师。由于九一八事变后全国人民抗日反蒋斗争空前高涨，国民党内部的矛盾日益加剧，敌军的“围剿”行动迟迟未能开始。十一月上旬成立的红四方面军，为破坏敌军的“围剿”计划，主动出击，至一九三二年六月，先后发起了黄安、商（城）潢（川）、苏家埠、潢（川）光（山）四次战役，歼敌约六万人，使国民党军队对鄂豫皖革命根据地的第三次“围剿”计划彻底破产。   
　　〔21〕一九三二年六月蒋介石调集三十余万军队对鄂豫皖革命根据地进行第四次“围剿”。当时担任中共鄂豫皖中央分局书记的张国焘，被前三次反“围剿”的胜利冲昏头脑，在国民党军队的严重“围剿”面前，没有领导红军进行反“围剿”的准备，而是强令红军围攻敌军坚固设防的城市，准备夺取武汉。当敌军大举进攻时，他不是采取诱敌深入、待机反击的作战方针，而是下令红军仓卒迎击，使红军陷于被动地位。一九三二年十月，红四方面军主力被迫转移外线作战。此后，再未返回根据地，鄂豫皖革命根据地第四次反“围剿”斗争遭到失败。   
　　〔22〕指俄国一九〇五年革命失败以后，革命由高涨时期转入逐渐低落时期的退却。参见列宁《共产主义运动中的“左派”幼稚病》第三节（《列宁全集》第39卷，人民出版社1986年版，第6—11页）和《联共（布）党史简明教程》第三章第五、第六两节（人民出版社1975年版，第88—105页）。   
　　〔23〕布列斯特条约是一九一八年三月苏俄在俄国西部布列斯特—里托夫斯克（今布列斯特）同德国、奥匈帝国、保加利亚、土耳其订立的和约。当时，德帝国主义的军队正侵入苏维埃共和国境内，前线的俄国旧军队已经瓦解，新的革命军队还没有组织起来。为了使刚成立的苏维埃共和国避免在德军的打击下夭折，列宁主张暂时退却，接受德帝国主义提出的割地、赔款等条件，立刻签订和约。这个和约的签订，使苏维埃共和国赢得了时间去巩固无产阶级的政权，调整经济，建立红军，使无产阶级保持了对农民的领导，集聚了力量，得以在一九一八年至一九二〇年击溃白军和英、美、法、日、波等国武装干涉者。   
　　〔24〕一九二七年十月底，广东海陆丰农民在中国共产党领导下决定举行第三次起义。十一月，占领海丰、陆丰和附近地区，组织红军，建立工农民主政权。到一九二八年三月，这个地区的红军因优势敌军的围攻以及领导指挥上的“左”倾盲动而遭到失败。   
　　〔25〕一九三六年七月，红四方面军和红二方面军会合后，由于中共中央的积极争取，并经过朱德、刘伯承等以及四方面军广大指战员的斗争，张国焘被迫同意与二方面军共同北上，于同年十月到达甘肃会宁。十月下旬，四方面军一部奉中央军委指示西渡黄河，执行宁夏战役计划。十一月上旬根据中共中央和中央军委的决定，过河部队称西路军。他们在极端困难的条件下孤军奋战四个月，歼敌二万余人，终因敌众我寡，于一九三七年三月失败。   
　　〔26〕见马克思一八七一年四月十二日致库格曼论巴黎公社的信（《马克思恩格斯选集》第4卷，人民出版社1972年版，第392—393页）；参见恩格斯《德国的革命和反革命》第十七节（《马克思恩格斯选集》第1卷，人民出版社1972年版，第585—586页）。   
　　〔27〕《水浒传》是中国描写农民战争的著名小说，相传为公元十四世纪元末明初人施耐庵所作。林冲、柴进都是书中的英雄人物。洪教头是柴进家里的一个武术教师。关于林冲和洪教头比武的故事，见《水浒传》第九回《柴进门招天下客，林冲棒打洪教头》。   
　　〔28〕鲁和齐是中国春秋时代（公元前七二二——前四八一）的两个国家。齐是大国，在今山东省的中部和东北部；鲁国较小，在今山东省的南部。鲁庄公，公元前六九三年至前六六二年鲁国的国君。   
　　〔29〕 左丘明，春秋末期鲁国人，相传是春秋时代著名编年史《左传》的作者。本文引的一段文章见《左传·庄公十年》。   
　　〔30〕 “肉食者”指做官的。“又何间焉”，是“何必厕身其间”的意思。“牺牲玉帛，弗敢加也，必以信”一句中，牺牲玉帛是祀神的物品，“加”是虚报的意思。鲁庄公说他据实报告祭品，表示他对神守信用。“忠之属也。可以一战”，“忠”是尽力做好本分的事。曹刿的意思是说：一个国君对狱讼处置得合乎情理，便会得到人民拥护，所以可以作战。“公将鼓之”和“齐人三鼓”的“鼓”，都是说鸣鼓指挥士兵冲锋。“登轼而望之”的“轼”，是车前供给乘者扶手的横木，在车上位置较高，所以登轼可以望远。   
　　〔31〕成皋故城在今河南省荥阳县西北部，为古代军事重地。公元前二〇三年，汉王刘邦和楚王项羽曾相持于此。当时项羽接连攻下荥阳、成皋，刘邦几乎溃不成军。但后来刘邦终于等待到楚军在汜水半渡的时机，大破楚军，复取成皋。   
　　〔32〕昆阳故城在今河南省叶县境内。公元二三年，刘秀（后称东汉光武帝）在这里击破王莽（公元八年称帝，定国号为新）的军队。这次战争双方军力强弱悬殊，刘秀只有八九千人，而王莽有四十余万人。但刘秀利用王莽的将军王寻、王邑轻敌懈怠，以精兵三千突破王莽军队的中坚，乘锐进击，大破敌军。   
　　〔33〕官渡在今河南省中牟县东北。公元二〇〇年，曹操军队和袁绍军队战于此处。当时袁绍拥军十万，而曹操兵少粮尽。但曹操利用袁军的轻敌无备，实行轻兵偷袭，烧了袁军的辎重。袁军慌乱，曹军出击，歼灭了袁军主力。   
　　〔34〕吴指孙权方面，魏指曹操方面。赤壁在今湖北省蒲圻县西北长江南岸。公元二〇八年，曹操率兵数十万进攻孙权。孙权出兵三万，并且同刘备联合，利用曹军有疫疾，又不习水战，在赤壁一带用火攻烧曹军船只，大破曹军。   
　　〔35〕彝陵在今湖北省宜昌县境内。公元二二二年，吴将陆逊在这里大败蜀汉的刘备。这次战争开始，蜀军连战皆捷，进到彝陵，已入吴境五六百里。陆逊守七八月不战，直待刘备“兵疲意沮，计不复生”，利用顺风放火，大破蜀军。   
　　〔36〕公元三八三年，东晋将军谢玄大败秦王苻坚于安徽淝水。当时苻坚有步兵六十余万、骑兵二十七万、卫队三万余骑，东晋只有水陆军八万。在两军隔淝水对峙的时候，晋军将领要求淝水以北的秦军让出一片战场来，以便晋军渡水决战。秦军应允后撤，但一退即不可遏止，晋军乘机渡水攻击，大败秦军。   
　　〔37〕一九二七年八月一日，中国共产党为反对蒋介石、汪精卫的反革命，继续一九二四年至一九二七年的革命事业，在江西南昌发动了武装起义。起义部队在中共前敌委员会书记周恩来和贺龙、叶挺、朱德、刘伯承等领导下，经过激烈战斗，占领了南昌城。这次起义打响了中国人民武装反抗国民党反动派的第一枪。从此，开始了中国共产党独立领导革命武装斗争的新时期。起义部队撤离南昌后南下广东。十月初在潮州、汕头一带遇到优势敌军的围攻而失败。保存下来的起义部队，一部分到达海陆丰地区，继续坚持斗争；另一部分在朱德、陈毅等率领下，转移到湘南，发动了湘南起义，一九二八年四月在井冈山同毛泽东领导的工农革命军会师。   
　　〔38〕 参见本卷《中国的红色政权为什么能够存在？》注〔8〕。   
　　〔39〕〕一九二七年革命失败以后，中国共产党在湖南、湖北、江西、广东等省发动秋收起义。其中最著名的是九月间毛泽东在湖南、江西边界的修水、铜鼓、萍乡、醴陵、平江、浏阳等地领导的起义。参加这次起义的工农武装和原国民革命军第四集团军第二方面军总指挥部警卫团，组成了工农革命军第一军第一师。十月间，毛泽东率领这支军队转战到井冈山，在那里建立了第一个农村革命根据地。   
　　〔40〕 见本卷《关心群众生活，注意工作方法》注〔5〕。   
　　〔41〕 见《孙子·军争》。   
　　〔42〕 AB团是一九二六年底在江西南昌成立的以反共为目的的国民党右派组织，存在时间不长。一九三〇年五月起，赣西南苏区内开展了所谓肃清AB团的斗争。斗争不断扩大，严重混淆了敌我矛盾。   
　　〔43〕 指江西省中部介于赣江和抚河两条河流之间的地区。   
　　〔44〕参见《战国策·魏策》。原文是：“将欲败之，必姑辅之；将欲取之，必姑与之。”   
　　〔45〕阿比西尼亚即埃塞俄比亚。一九三五年十月，意大利法西斯出兵进攻埃塞俄比亚。埃军进行阵地战，至一九三六年五月失败。第二次世界大战开始后，埃塞俄比亚人民在一九四一年与反法西斯盟军配合，赶走了意大利侵略军，恢复了国家的独立。   
　　〔46〕 这里所说的藏人，主要是指西康（现在分属四川和西藏）、甘肃的藏族。这里所说的回人，是指甘肃、青海、新疆的回族。   
　　〔47〕刘，指国民党军刘和鼎师。   
　　〔48〕第三次“围剿”时，蒋介石担任“围剿”军总司令，何应钦任前线总司令，其指挥部均驻南昌。下辖：左翼集团军，何应钦兼任总司令；右翼集团军，陈铭枢任总司令，驻吉安；预备军，卫立煌任总指挥，驻临川。   
　　〔49〕蒋光鼐原是第十九路军总指挥，第二次“围剿”时，由蔡廷锴任代总指挥。第三次“围剿”时，第十九路军蔡廷锴第六十师、戴戟第六十一师和韩德勤第五十二师被编为右翼集团军第一军团，蔡廷锴任代总指挥。这里的“蒋光鼐、蔡廷锴、韩德勤”，应是“蔡廷锴、戴戟、韩德勤”；下文的“蒋、蔡、韩”应是“蔡、戴、韩”，“蒋光鼐、蔡廷锴”应是“蔡廷锴、戴戟”。   
　　〔50〕 第三次反“围剿”时，红一方面军打上官云相师、郝梦龄师、毛炳文师，三个胜仗共歼敌一万余人，缴枪六千多支。   
　　〔51〕南雄、水口战役，包括池江、梅岭关、大余、水口圩等战斗，共击溃陈济棠的粤军十五个团。其中水口圩战斗，击溃粤军十个团。   
　　〔52〕八股文是中国明、清封建皇朝考试制度所规定的一种特殊文体。八股文每篇由破题、承题、起讲、入手、起股、中股、后股、束股八部分组成。破题一般用两句，说破题目的要义。承题一般用三句至五句，承接破题的意义而说明之。起讲概说全体，是议论的开始。入手为起讲后入手之处。起股、中股、后股和束股这四个段落才是正式的议论，中股为全篇文字的重心。在这四个段落中，每一段落都有两股两相比偶的文字，合共有八股，所以叫作八股文，也称为八比。毛泽东这里用写作八股文由一部分到另一部分的展开过程，来比喻革命发展的各种阶段。但在通常的场合，毛泽东则用八股文这类东西去比喻和讽刺教条主义。   
　　〔53〕见《左传·成公二年》。公元前五八九年，齐、晋两国的军队会战于鞌（今属山东省历城县）。战斗一开始，齐顷公以为胜敌至易，说：“余姑翦灭此而朝食”。“此”，指这些敌人。这句话的意思是：先消灭了这些敌人，再吃早饭。结果齐军被晋军打败。后来人们常以此形容斗志坚决，要立即消灭敌人。   